@echo off
REM DAYBot - Start All Services
REM This starts BOTH scheduler and queue worker
REM Path: C:\xampp\htdocs\daybot.tv\run-all.bat

title DAYBot - Starting All Services

echo.
echo ========================================
echo   DAYBot - Starting All Services
echo ========================================
echo.
echo Starting:
echo   1. Scheduler (polls YouTube chat every 1 second)
echo   2. Queue Worker (processes messages and replies)
echo.
echo Both windows will open in minimized mode
echo ========================================
echo.

cd /d "C:\xampp\htdocs\daybot.tv"

REM Start Scheduler in new minimized window
start "DAYBot Scheduler" /min cmd /c run-scheduler.bat

REM Wait 2 seconds
timeout /t 2 /nobreak > nul

REM Start Queue Worker in new minimized window
start "DAYBot Queue Worker" /min cmd /c queue-worker.bat

echo.
echo ========================================
echo   ✅ All Services Started!
echo ========================================
echo.
echo Two background windows are now running:
echo   - DAYBot Scheduler (polling every 1 second)
echo   - DAYBot Queue Worker (processing messages)
echo.
echo To view status:
echo   - Check Windows Task Manager
echo   - Look for "DAYBot Scheduler" and "DAYBot Queue Worker"
echo.
echo To stop services:
echo   - Close both minimized windows from taskbar
echo   OR
echo   - Run: taskkill /FI "WINDOWTITLE eq DAYBot*" /F
echo.
echo Press any key to exit this window...
pause > nul
