<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Tenant;

echo "=== Setting Default Response Length to Medium (200 chars) ===\n\n";

$tenants = Tenant::all();

foreach ($tenants as $tenant) {
    $tenant->settings()->updateOrCreate(
        ['key' => 'response_length'],
        ['value' => 'medium']
    );

    echo "✅ Tenant #{$tenant->id} ({$tenant->channel_title}): response_length = medium\n";
}

echo "\n✅ All tenants updated to default response length: medium (200 characters)\n";
echo "🔄 Restart queue workers to apply changes: stop-all.bat then run-all.bat\n";
