<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Tenant;

echo "=== Setting Default Roasting Level to Dark ===\n\n";

$tenants = Tenant::all();

foreach ($tenants as $tenant) {
    $tenant->settings()->updateOrCreate(
        ['key' => 'roasting_level'],
        ['value' => 'dark']
    );

    $tenant->settings()->updateOrCreate(
        ['key' => 'response_length'],
        ['value' => 'medium']
    );

    echo "✅ Tenant #{$tenant->id} ({$tenant->channel_title}): roasting_level = dark, response_length = medium\n";
}

echo "\n✅ All tenants updated!\n";
echo "🔥 Roasting Level: DARK (brutally honest and cutting)\n";
echo "📏 Response Length: MEDIUM (200 characters)\n";
echo "\n🔄 Restart queue workers to apply changes: stop-all.bat then run-all.bat\n";
