<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Tenant;

echo "=== Manual Stream Context Setup ===\n\n";

$tenantId = $argv[1] ?? null;
$streamType = $argv[2] ?? null;
$currentGame = $argv[3] ?? null;

if (!$tenantId || !$streamType) {
    echo "Usage: php set-stream-context.php <tenant_id> <stream_type> [current_game]\n\n";
    echo "Stream Types:\n";
    echo "  - gaming\n";
    echo "  - tech\n";
    echo "  - music\n";
    echo "  - cooking\n";
    echo "  - fitness\n";
    echo "  - vlog\n";
    echo "  - education\n";
    echo "  - comedy\n";
    echo "  - art\n";
    echo "  - sports\n";
    echo "  - other\n\n";
    echo "Examples:\n";
    echo "  php set-stream-context.php 16 gaming \"GTA V\"\n";
    echo "  php set-stream-context.php 16 tech\n";
    echo "  php set-stream-context.php 16 gaming Valorant\n\n";
    exit(1);
}

$tenant = Tenant::find($tenantId);

if (!$tenant) {
    echo "❌ Tenant #{$tenantId} not found!\n";
    exit(1);
}

echo "Tenant: {$tenant->channel_title}\n";
echo "Setting stream context...\n\n";

$description = match($streamType) {
    'gaming' => $currentGame ? "Gaming channel playing {$currentGame}" : "Gaming channel",
    'tech' => "Technology and tech content",
    'music' => "Music and entertainment",
    'cooking' => "Cooking and food content",
    'fitness' => "Fitness and workout content",
    'vlog' => "Vlog and lifestyle content",
    'education' => "Educational content",
    'comedy' => "Comedy and entertainment",
    'art' => "Art and creative content",
    'sports' => "Sports content",
    default => "General content",
};

$tenant->update([
    'stream_type' => $streamType,
    'current_game' => $currentGame,
    'stream_description' => $description,
    'stream_context_updated_at' => now(),
]);

echo "✅ Stream context updated!\n\n";
echo "Stream Type: {$streamType}\n";
echo "Current Game: " . ($currentGame ?: 'N/A') . "\n";
echo "Description: {$description}\n";
echo "Updated At: " . now()->format('Y-m-d H:i:s') . "\n\n";

echo "🎯 Bot will now use this context in all replies and roasts!\n";
echo "📝 Restart queue workers to apply changes: stop-all.bat then run-all.bat\n";
