<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-8">
        <a href="<?php echo e(route('admin.index')); ?>" class="inline-flex items-center text-gray-400 hover:text-gray-300 mb-4 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Admin
        </a>
        <h2 class="text-3xl font-bold text-white">Message Logs</h2>
        <p class="mt-2 text-gray-400">Chat messages for <span class="text-indigo-400"><?php echo e($tenant->channel_title); ?></span></p>
    </div>

    <!-- Logs Table -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800/50">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Time</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Author</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Message</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Type</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-800/30 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-400">
                            <?php echo e($message->created_at->format('M d, H:i:s')); ?>

                        </td>
                        <td class="px-6 py-4">
                            <div>
                                <p class="text-sm font-medium text-white"><?php echo e($message->author_name); ?></p>
                                <p class="text-xs text-gray-500"><?php echo e($message->author_channel_id); ?></p>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <p class="text-sm text-gray-300"><?php echo e($message->text); ?></p>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs font-medium rounded-full <?php echo e($message->direction === 'outbound' ? 'bg-blue-500/20 text-blue-400' : 'bg-gray-500/20 text-gray-400'); ?>">
                                <?php echo e($message->direction); ?>

                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4" class="px-6 py-12 text-center text-gray-400">
                            No messages found
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php if($messages->hasPages()): ?>
    <div class="mt-6">
        <?php echo e($messages->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\daybot.tv\resources\views/admin/logs.blade.php ENDPATH**/ ?>