<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-6 lg:px-8 py-12">
    <div class="bg-card rounded-2xl border border-subtle p-8 md:p-12">
        <h1 class="text-4xl font-bold text-main mb-4">Terms of Service</h1>
        <p class="text-sm text-muted mb-8">Last Updated: <?php echo e(date('F d, Y')); ?></p>

        <div class="prose prose-invert max-w-none space-y-8">
            <!-- Agreement to Terms -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">1. Agreement to Terms</h2>
                <p class="text-secondary leading-relaxed">
                    Welcome to Daybot. By accessing and using Daybot ("Service," "we," "us," or "our"), you agree to be bound by these Terms of Service ("Terms") and all applicable laws and regulations. If you do not agree with any of these terms, you are prohibited from using or accessing this service.
                </p>
                <p class="text-secondary leading-relaxed mt-4">
                    These Terms constitute a legally binding agreement between you and Daybot. Please read them carefully before using our service.
                </p>
                <div class="bg-warning/10 border border-warning/30 rounded-lg p-4 mt-4">
                    <p class="text-warning text-sm font-medium flex items-start">
                        <svg class="w-5 h-5 mr-2 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                        <span><strong>Important:</strong> By using Daybot, you are also agreeing to be bound by the <a href="https://www.youtube.com/t/terms" target="_blank" class="underline hover:text-warning/80">YouTube Terms of Service</a> and <a href="https://www.google.com/policies/privacy" target="_blank" class="underline hover:text-warning/80">Google Privacy Policy</a>.</span>
                    </p>
                </div>
            </section>

            <!-- YouTube API Services Compliance -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">2. YouTube API Services Compliance</h2>
                <p class="text-secondary leading-relaxed mb-4">
                    Daybot uses <strong>YouTube API Services</strong> to provide chatbot functionality for YouTube live streams. Your use of Daybot is subject to:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>The <a href="https://www.youtube.com/t/terms" target="_blank" class="text-accent-primary hover:underline">YouTube Terms of Service</a></li>
                    <li>The <a href="https://policies.google.com/privacy" target="_blank" class="text-accent-primary hover:underline">Google Privacy Policy</a></li>
                    <li>The <a href="https://developers.google.com/youtube/terms/developer-policies" target="_blank" class="text-accent-primary hover:underline">YouTube API Services Terms of Service</a></li>
                    <li>The <a href="https://developers.google.com/terms/api-services-user-data-policy" target="_blank" class="text-accent-primary hover:underline">Google API Services User Data Policy</a></li>
                </ul>
                <p class="text-secondary leading-relaxed mt-4">
                    You acknowledge that by connecting your YouTube account to Daybot through OAuth authentication, you grant us permission to access your YouTube channel data as described in our <a href="<?php echo e(route('privacy-policy')); ?>" class="text-accent-primary hover:underline">Privacy Policy</a>. You can revoke this access at any time through your <a href="https://myaccount.google.com/permissions" target="_blank" class="text-accent-primary hover:underline">Google Account Permissions page</a>.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">2.1 YouTube Data Usage</h3>
                <p class="text-secondary leading-relaxed mb-3">
                    Daybot accesses the following YouTube data on your behalf:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>Your YouTube channel information (name, ID, profile picture)</li>
                    <li>Live chat messages from your YouTube live streams</li>
                    <li>Chat participant information (usernames, user IDs)</li>
                    <li>Live broadcast details (stream ID, chat ID)</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-3">
                    This data is used <strong>exclusively</strong> to provide the Daybot service functionality as described in these Terms and our Privacy Policy.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">2.2 YouTube Community Guidelines</h3>
                <p class="text-secondary leading-relaxed">
                    You agree to configure and use Daybot in compliance with <a href="https://www.youtube.com/howyoutubeworks/policies/community-guidelines/" target="_blank" class="text-accent-primary hover:underline">YouTube Community Guidelines</a>. You are solely responsible for the content your bot posts to YouTube. We reserve the right to terminate accounts that violate YouTube policies.
                </p>
            </section>

            <!-- Service Description -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">3. Service Description</h2>
                <p class="text-secondary leading-relaxed mb-4">
                    Daybot is a YouTube live chat automation bot designed to help content creators manage their live stream chats more effectively. The service provides the following features:
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">3.1 Core Features</h3>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li><strong>AI-Powered Responses:</strong> Intelligent, context-aware responses using OpenAI language models (optional feature)</li>
                    <li><strong>Custom Commands:</strong> Create and manage custom chat commands with predefined responses</li>
                    <li><strong>Smart Moderation:</strong> Automated content moderation with banned keyword detection, timeout, and ban functionality</li>
                    <li><strong>Spam Protection:</strong> User cooldown system to prevent spam and rate limit abuse</li>
                    <li><strong>Automated Timers:</strong> Schedule recurring messages based on time intervals or activity triggers</li>
                    <li><strong>Auto Greetings:</strong> Automatically greet new viewers and recognize returning subscribers</li>
                    <li><strong>Real-Time Analytics:</strong> Message statistics, command usage tracking, and engagement metrics</li>
                    <li><strong>Stream Context Awareness:</strong> Bot understands stream titles and can provide context-aware responses</li>
                    <li><strong>Rate Limiting & Quota Management:</strong> Configurable message rate limits to prevent YouTube API quota exhaustion</li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">3.2 Service Availability</h3>
                <p class="text-secondary leading-relaxed">
                    We strive to provide reliable service, but we do not guarantee that Daybot will be available 100% of the time. The service may be temporarily unavailable due to maintenance, updates, technical issues, or circumstances beyond our control.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">3.3 Service Limitations</h3>
                <p class="text-secondary leading-relaxed mb-3">
                    Daybot operates within the limitations of YouTube API Services, including:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>YouTube API quota limits (shared across all users)</li>
                    <li>Rate limits on message posting (default: 200/minute, 2000/hour per tenant)</li>
                    <li>Delayed message delivery during high-traffic periods</li>
                    <li>Potential service interruptions due to YouTube API changes or outages</li>
                </ul>
            </section>

            <!-- User Accounts and Registration -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">4. User Accounts and Registration</h2>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">4.1 Account Creation</h3>
                <p class="text-secondary leading-relaxed">
                    To use Daybot, you must:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4 mt-3">
                    <li>Create an account with accurate and complete information</li>
                    <li>Connect your YouTube channel through secure Google OAuth authentication</li>
                    <li>Provide a valid email address for account notifications</li>
                    <li>Agree to these Terms of Service and our Privacy Policy</li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">4.2 Account Security</h3>
                <p class="text-secondary leading-relaxed">
                    You are responsible for:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4 mt-3">
                    <li>Maintaining the confidentiality of your account password</li>
                    <li>All activities that occur under your account</li>
                    <li>Notifying us immediately of any unauthorized use of your account</li>
                    <li>Ensuring your account information remains accurate and up-to-date</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-3">
                    We will not be liable for any losses arising from unauthorized use of your account.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">4.3 Age Requirement</h3>
                <p class="text-secondary leading-relaxed">
                    You must be at least 13 years old (or the minimum age required in your country) to use Daybot. By using this service, you represent and warrant that you meet this age requirement.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">4.4 One Account Per User</h3>
                <p class="text-secondary leading-relaxed">
                    Each user is permitted one account. Creating multiple accounts to circumvent service limitations, bans, or rate limits is prohibited and may result in termination of all your accounts.
                </p>
            </section>

            <!-- Acceptable Use Policy -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">5. Acceptable Use Policy</h2>
                <p class="text-secondary leading-relaxed mb-3">You agree NOT to use Daybot to:</p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>Violate any applicable laws, regulations, or third-party rights</li>
                    <li>Post spam, harassment, hate speech, or abusive content through the bot</li>
                    <li>Impersonate others or provide false or misleading information</li>
                    <li>Interfere with, disrupt, or damage the service, servers, or networks</li>
                    <li>Attempt to gain unauthorized access to our systems, accounts, or data</li>
                    <li>Reverse engineer, decompile, or disassemble any part of the service</li>
                    <li>Use automated scripts or bots to access the service (except as intended)</li>
                    <li>Violate YouTube Terms of Service, Community Guidelines, or API policies</li>
                    <li>Post content that infringes intellectual property rights</li>
                    <li>Transmit viruses, malware, or other harmful code</li>
                    <li>Collect or harvest user data without consent</li>
                    <li>Use the service for any illegal or unauthorized purpose</li>
                    <li>Resell, sublicense, or commercially exploit the service without permission</li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">5.1 Content Responsibility</h3>
                <p class="text-secondary leading-relaxed">
                    You are solely responsible for all content your bot posts to YouTube live chats, including custom commands, automated responses, timer messages, and AI-generated content. You agree to ensure all bot-posted content complies with YouTube Community Guidelines and applicable laws.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">5.2 Prohibited Content</h3>
                <p class="text-secondary leading-relaxed mb-3">
                    You may not configure Daybot to post content that contains:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>Hate speech, discrimination, or harassment</li>
                    <li>Sexually explicit or pornographic material</li>
                    <li>Violence, gore, or graphic content</li>
                    <li>Scams, phishing attempts, or fraudulent schemes</li>
                    <li>Promotion of illegal activities or substances</li>
                    <li>Personal information or private data of others</li>
                    <li>Copyrighted material without proper authorization</li>
                </ul>
            </section>

            <!-- User Responsibilities -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">6. User Responsibilities</h2>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">6.1 Bot Configuration</h3>
                <p class="text-secondary leading-relaxed">
                    You are responsible for properly configuring your bot, including setting appropriate rate limits, moderation rules, and response content. Improper configuration may result in YouTube API quota exhaustion or account restrictions.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">6.2 Monitoring Bot Activity</h3>
                <p class="text-secondary leading-relaxed">
                    You should regularly monitor your bot's activity to ensure it operates as intended and complies with YouTube policies. We provide analytics and logs to help you track bot performance.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">6.3 YouTube API Quota Management</h3>
                <p class="text-secondary leading-relaxed">
                    You acknowledge that YouTube imposes API quota limits. While we provide rate limiting features, you are responsible for configuring appropriate limits to avoid exceeding your allocated quota.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">6.4 Third-Party AI Services</h3>
                <p class="text-secondary leading-relaxed">
                    If you enable AI-powered responses, you acknowledge that chat messages will be sent to OpenAI API for processing. You are responsible for ensuring compliance with OpenAI's policies and for reviewing AI-generated responses for appropriateness.
                </p>
            </section>

            <!-- Data and Privacy -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">7. Data and Privacy</h2>
                <p class="text-secondary leading-relaxed mb-3">
                    Your use of Daybot is subject to our <a href="<?php echo e(route('privacy-policy')); ?>" class="text-accent-primary hover:underline">Privacy Policy</a>, which explains how we collect, use, store, and protect your data. By using this service, you consent to our data practices as described in the Privacy Policy.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">7.1 Data You Provide</h3>
                <p class="text-secondary leading-relaxed">
                    By using Daybot, you provide us with access to your YouTube channel data, account information, and bot configuration settings. You represent that you have the right to share this data with us.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">7.2 Data Deletion</h3>
                <p class="text-secondary leading-relaxed">
                    You can request deletion of your data at any time by:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4 mt-3">
                    <li>Disconnecting your YouTube channel through your dashboard</li>
                    <li>Revoking OAuth access through your <a href="https://myaccount.google.com/permissions" target="_blank" class="text-accent-primary hover:underline">Google Account Permissions</a></li>
                    <li>Contacting us at <a href="mailto:support@daybot.tv" class="text-accent-primary hover:underline">support@daybot.tv</a> to request account deletion</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-3">
                    We will delete your data within 30 days of your request, except where retention is required by law.
                </p>
            </section>

            <!-- Intellectual Property -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">8. Intellectual Property</h2>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">8.1 Daybot Ownership</h3>
                <p class="text-secondary leading-relaxed">
                    The Service and its original content, features, functionality, source code, and design are owned by Daybot and are protected by international copyright, trademark, patent, trade secret, and other intellectual property laws.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">8.2 Your Content</h3>
                <p class="text-secondary leading-relaxed">
                    You retain ownership of custom commands, responses, and configurations you create using Daybot. However, you grant us a non-exclusive, worldwide license to use, store, and process this content solely for the purpose of providing the service.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">8.3 Trademarks</h3>
                <p class="text-secondary leading-relaxed">
                    "Daybot" and related logos are trademarks of Daybot. You may not use these trademarks without our prior written permission.
                </p>
            </section>

            <!-- Service Modifications and Termination -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">9. Service Modifications and Termination</h2>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">9.1 Service Changes</h3>
                <p class="text-secondary leading-relaxed">
                    We reserve the right to modify, suspend, or discontinue any part of the Service at any time, with or without notice. We will not be liable to you or any third party for any modification, suspension, or discontinuation of the Service.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">9.2 Account Termination by Us</h3>
                <p class="text-secondary leading-relaxed mb-3">
                    We may terminate or suspend your account immediately, without prior notice or liability, if:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>You breach these Terms of Service</li>
                    <li>You violate YouTube Terms of Service or Community Guidelines</li>
                    <li>Your use of the service poses a security or legal risk</li>
                    <li>We are required to do so by law or legal authority</li>
                    <li>We decide to discontinue the service</li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">9.3 Account Termination by You</h3>
                <p class="text-secondary leading-relaxed">
                    You may terminate your account at any time by:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4 mt-3">
                    <li>Contacting us at <a href="mailto:support@daybot.tv" class="text-accent-primary hover:underline">support@daybot.tv</a></li>
                    <li>Revoking access through your <a href="https://myaccount.google.com/permissions" target="_blank" class="text-accent-primary hover:underline">Google Account Permissions page</a></li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">9.4 Effect of Termination</h3>
                <p class="text-secondary leading-relaxed">
                    Upon termination, your right to use the Service will immediately cease. All provisions of these Terms that by their nature should survive termination shall survive, including ownership provisions, warranty disclaimers, indemnity, and limitations of liability.
                </p>
            </section>

            <!-- Disclaimer of Warranties -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">10. Disclaimer of Warranties</h2>
                <p class="text-secondary leading-relaxed mb-3">
                    THE SERVICE IS PROVIDED ON AN "AS IS" AND "AS AVAILABLE" BASIS WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>IMPLIED WARRANTIES OF MERCHANTABILITY</li>
                    <li>FITNESS FOR A PARTICULAR PURPOSE</li>
                    <li>NON-INFRINGEMENT</li>
                    <li>ACCURACY, RELIABILITY, OR AVAILABILITY</li>
                    <li>UNINTERRUPTED OR ERROR-FREE OPERATION</li>
                    <li>SECURITY OR FREEDOM FROM VIRUSES</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-4">
                    WE DO NOT WARRANT THAT THE SERVICE WILL MEET YOUR REQUIREMENTS OR THAT ANY ERRORS WILL BE CORRECTED. YOUR USE OF THE SERVICE IS AT YOUR OWN RISK.
                </p>
            </section>

            <!-- Limitation of Liability -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">11. Limitation of Liability</h2>
                <p class="text-secondary leading-relaxed mb-3">
                    TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL DAYBOT, ITS DIRECTORS, EMPLOYEES, PARTNERS, AGENTS, SUPPLIERS, OR AFFILIATES BE LIABLE FOR:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>ANY INDIRECT, INCIDENTAL, SPECIAL, CONSEQUENTIAL, OR PUNITIVE DAMAGES</li>
                    <li>ANY LOSS OF PROFITS, REVENUE, DATA, OR USE</li>
                    <li>ANY LOSS OF GOODWILL OR REPUTATION</li>
                    <li>ANY INTERRUPTION OF BUSINESS OR SERVICE</li>
                    <li>ANY DAMAGES RESULTING FROM UNAUTHORIZED ACCESS TO YOUR DATA</li>
                    <li>ANY DAMAGES ARISING FROM YOUR USE OR INABILITY TO USE THE SERVICE</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-4">
                    THIS LIMITATION APPLIES WHETHER THE ALLEGED LIABILITY IS BASED ON CONTRACT, TORT, NEGLIGENCE, STRICT LIABILITY, OR ANY OTHER BASIS, EVEN IF WE HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
                </p>
                <p class="text-secondary leading-relaxed mt-3">
                    IN JURISDICTIONS THAT DO NOT ALLOW THE EXCLUSION OR LIMITATION OF LIABILITY, OUR LIABILITY SHALL BE LIMITED TO THE MAXIMUM EXTENT PERMITTED BY LAW.
                </p>
            </section>

            <!-- Indemnification -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">12. Indemnification</h2>
                <p class="text-secondary leading-relaxed">
                    You agree to defend, indemnify, and hold harmless Daybot and its officers, directors, employees, contractors, agents, licensors, and suppliers from and against any claims, liabilities, damages, judgments, awards, losses, costs, expenses, or fees (including reasonable attorneys' fees) arising out of or relating to:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4 mt-3">
                    <li>Your violation of these Terms of Service</li>
                    <li>Your violation of any rights of another party</li>
                    <li>Your violation of any applicable laws or regulations</li>
                    <li>Content posted by your bot to YouTube</li>
                    <li>Your use or misuse of the Service</li>
                </ul>
            </section>

            <!-- Dispute Resolution -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">13. Dispute Resolution</h2>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">13.1 Informal Resolution</h3>
                <p class="text-secondary leading-relaxed">
                    If you have any dispute with us, you agree to first contact us at <a href="mailto:support@daybot.tv" class="text-accent-primary hover:underline">support@daybot.tv</a> and attempt to resolve the dispute informally before pursuing any legal action.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">13.2 Arbitration</h3>
                <p class="text-secondary leading-relaxed">
                    Any disputes that cannot be resolved informally shall be resolved through binding arbitration in accordance with applicable arbitration rules, rather than in court, except that you may assert claims in small claims court if your claims qualify.
                </p>
            </section>

            <!-- Changes to These Terms -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">14. Changes to These Terms</h2>
                <p class="text-secondary leading-relaxed">
                    We reserve the right to modify these Terms of Service at any time. We will notify users of any material changes by:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4 mt-3">
                    <li>Updating the "Last Updated" date at the top of this page</li>
                    <li>Sending an email notification to your registered email address</li>
                    <li>Displaying a prominent notice on your dashboard</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-3">
                    Your continued use of the Service after changes become effective constitutes acceptance of the modified Terms. If you do not agree to the modified Terms, you must stop using the Service.
                </p>
            </section>

            <!-- Governing Law and Jurisdiction -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">15. Governing Law and Jurisdiction</h2>
                <p class="text-secondary leading-relaxed">
                    These Terms shall be governed by and construed in accordance with applicable laws, without regard to conflict of law provisions. Any legal action or proceeding arising under these Terms shall be brought exclusively in the courts of competent jurisdiction.
                </p>
            </section>

            <!-- Severability -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">16. Severability</h2>
                <p class="text-secondary leading-relaxed">
                    If any provision of these Terms is found to be invalid, illegal, or unenforceable, the remaining provisions shall continue in full force and effect. The invalid provision shall be modified to the minimum extent necessary to make it valid and enforceable.
                </p>
            </section>

            <!-- Entire Agreement -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">17. Entire Agreement</h2>
                <p class="text-secondary leading-relaxed">
                    These Terms of Service, together with our Privacy Policy, constitute the entire agreement between you and Daybot regarding the use of the Service, superseding any prior agreements between you and Daybot relating to your use of the Service.
                </p>
            </section>

            <!-- Contact Information -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">18. Contact Us</h2>
                <p class="text-secondary leading-relaxed mb-3">
                    If you have any questions, concerns, or feedback regarding these Terms of Service, please contact us:
                </p>
                <div class="bg-surface rounded-lg p-6 mt-4">
                    <p class="text-secondary"><strong class="text-main">Email:</strong> <a href="mailto:support@daybot.tv" class="text-accent-primary hover:underline">support@daybot.tv</a></p>
                    <p class="text-secondary mt-2"><strong class="text-main">Website:</strong> <a href="https://daybot.tv" target="_blank" class="text-accent-primary hover:underline">https://daybot.tv</a></p>
                    <p class="text-secondary mt-2"><strong class="text-main">Official Domain:</strong> daybot.tv</p>
                </div>
                <p class="text-secondary leading-relaxed mt-4">
                    We will respond to your inquiry within 30 days.
                </p>
            </section>

            <!-- Back to Home -->
            <div class="pt-8 border-t border-subtle mt-12">
                <a href="<?php echo e(route('welcome')); ?>" class="inline-flex items-center text-accent-primary hover:text-accent-secondary mr-6">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                    </svg>
                    Back to Home
                </a>
                <?php if(auth()->guard()->check()): ?>
                <a href="<?php echo e(route('dashboard')); ?>" class="inline-flex items-center text-accent-primary hover:text-accent-secondary">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                    </svg>
                    Back to Dashboard
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\daybot.tv\resources\views/pages/terms-of-service.blade.php ENDPATH**/ ?>