<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', 'DAYBot')); ?> - YouTube Chat Bot</title>

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap');

        * {
            font-family: 'Inter', system-ui, -apple-system, BlinkMacSystemFont, sans-serif;
        }

        /* Modern Dark Theme - Linear/Vercel inspired */
        :root {
            --bg-body: #09090b;
            --bg-card: #18181b;
            --bg-surface: #27272a;
            --border-subtle: #3f3f46;
            --border-hover: #52525b;
            --text-main: #fafafa;
            --text-secondary: #d4d4d8;
            --text-muted: #a1a1aa;
            --text-dimmed: #71717a;
            --accent-primary: #8b5cf6;
            --accent-secondary: #6366f1;
            --success: #22c55e;
            --danger: #ef4444;
            --warning: #f59e0b;
        }

        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }

        /* Background colors */
        .bg-body { background-color: var(--bg-body); }
        .bg-card { background-color: var(--bg-card); }
        .bg-surface { background-color: var(--bg-surface); }

        /* Text colors */
        .text-main { color: var(--text-main); }
        .text-secondary { color: var(--text-secondary); }
        .text-muted { color: var(--text-muted); }
        .text-dimmed { color: var(--text-dimmed); }

        /* Border colors */
        .border-subtle { border-color: var(--border-subtle); }
        .border-hover { border-color: var(--border-hover); }

        /* Accent colors */
        .bg-accent-primary { background-color: var(--accent-primary); }
        .text-accent-primary { color: var(--accent-primary); }
        .bg-accent-secondary { background-color: var(--accent-secondary); }
        .text-accent-secondary { color: var(--accent-secondary); }

        /* Status colors */
        .bg-success { background-color: var(--success); }
        .text-success { color: var(--success); }
        .bg-danger { background-color: var(--danger); }
        .text-danger { color: var(--danger); }
        .bg-warning { background-color: var(--warning); }
        .text-warning { color: var(--warning); }

        /* Hover states */
        .hover\:bg-surface-hover:hover { background-color: rgba(255, 255, 255, 0.05); }
        .hover\:bg-accent-primary-hover:hover { background-color: #7c3aed; }
        .hover\:bg-success-hover:hover { background-color: #16a34a; }
        .hover\:bg-danger-hover:hover { background-color: #dc2626; }

        /* Gradient backgrounds */
        .bg-gradient-purple {
            background: linear-gradient(135deg, #8b5cf6 0%, #6366f1 100%);
        }

        .bg-gradient-purple-dark {
            background: linear-gradient(135deg, rgba(139, 92, 246, 0.15) 0%, rgba(99, 102, 241, 0.15) 100%);
        }

        /* Glass effect */
        .glass-effect {
            background: rgba(24, 24, 27, 0.8);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }

        /* Scrollbar styling */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: var(--bg-body);
        }

        ::-webkit-scrollbar-thumb {
            background: var(--border-subtle);
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--border-hover);
        }

        /* Focus ring */
        .focus-ring:focus {
            outline: none;
            box-shadow: 0 0 0 2px var(--bg-body), 0 0 0 4px var(--accent-primary);
        }

        /* Animations */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-4px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .animate-fade-in {
            animation: fadeIn 0.2s ease-out;
        }

        /* Selection */
        ::selection {
            background: rgba(139, 92, 246, 0.3);
        }
    </style>
</head>
<body class="bg-body text-main antialiased min-h-screen">
    <div class="flex flex-col min-h-screen" x-data="{ mobileMenuOpen: false, setupGuideOpen: false }">

        <!-- Navigation Header -->
        <header class="sticky top-0 z-50 glass-effect border-b border-subtle/50">
            <nav class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex items-center justify-between h-16">
                    <!-- Logo -->
                    <a href="<?php echo e(route('dashboard')); ?>" class="flex items-center gap-3 group">
                        <div class="w-9 h-9 rounded-xl bg-gradient-purple flex items-center justify-center shadow-lg shadow-purple-500/20 group-hover:shadow-purple-500/30 transition-shadow">
                            <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                            </svg>
                        </div>
                        <div class="hidden sm:block">
                            <span class="text-lg font-bold bg-gradient-to-r from-purple-400 to-indigo-400 bg-clip-text text-transparent">DAYBot</span>
                            <p class="text-[10px] text-muted -mt-0.5">YouTube Chat Bot</p>
                        </div>
                    </a>

                    <!-- Desktop Navigation -->
                    <div class="hidden md:flex items-center gap-1">
                        <a href="<?php echo e(route('dashboard')); ?>"
                           class="flex items-center gap-2 px-4 py-2 rounded-lg text-sm font-medium transition-all <?php echo e(request()->routeIs('dashboard') ? 'bg-surface text-main' : 'text-muted hover:text-main hover:bg-surface/50'); ?>">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                            </svg>
                            Dashboard
                        </a>

                        <button @click="setupGuideOpen = true"
                                class="flex items-center gap-2 px-4 py-2 rounded-lg text-sm font-medium text-muted hover:text-main hover:bg-surface/50 transition-all">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                            </svg>
                            Setup Guide
                        </button>

                        <?php if(auth()->check() && auth()->user()->isAdmin()): ?>
                        <a href="<?php echo e(route('admin.index')); ?>"
                           class="flex items-center gap-2 px-4 py-2 rounded-lg text-sm font-medium transition-all <?php echo e(request()->routeIs('admin.*') ? 'bg-surface text-main' : 'text-muted hover:text-main hover:bg-surface/50'); ?>">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                            </svg>
                            Admin
                        </a>
                        <?php endif; ?>
                    </div>

                    <!-- User Menu -->
                    <div class="flex items-center gap-3">
                        <?php if(auth()->check()): ?>
                        <div class="hidden sm:flex items-center gap-3">
                            <div class="flex items-center gap-2 px-3 py-1.5 bg-surface/50 rounded-lg border border-subtle/50">
                                <div class="w-7 h-7 rounded-lg bg-gradient-purple flex items-center justify-center text-white text-xs font-bold shadow">
                                    <?php echo e(strtoupper(substr(auth()->user()->name, 0, 1))); ?>

                                </div>
                                <span class="text-sm font-medium text-secondary max-w-[120px] truncate"><?php echo e(auth()->user()->name); ?></span>
                            </div>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit"
                                        class="px-4 py-2 bg-surface hover:bg-surface-hover text-muted hover:text-main rounded-lg text-sm font-medium border border-subtle/50 hover:border-subtle transition-all">
                                    Logout
                                </button>
                            </form>
                        </div>
                        <?php endif; ?>

                        <!-- Mobile Menu Toggle -->
                        <button @click="mobileMenuOpen = !mobileMenuOpen"
                                class="md:hidden p-2 rounded-lg text-muted hover:text-main hover:bg-surface transition-colors">
                            <svg x-show="!mobileMenuOpen" class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                            <svg x-show="mobileMenuOpen" x-cloak class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                </div>

                <!-- Mobile Navigation -->
                <div x-show="mobileMenuOpen"
                     x-transition:enter="transition ease-out duration-200"
                     x-transition:enter-start="opacity-0 -translate-y-2"
                     x-transition:enter-end="opacity-100 translate-y-0"
                     x-transition:leave="transition ease-in duration-150"
                     x-transition:leave-start="opacity-100 translate-y-0"
                     x-transition:leave-end="opacity-0 -translate-y-2"
                     class="md:hidden border-t border-subtle/50 py-4 space-y-2"
                     x-cloak>
                    <a href="<?php echo e(route('dashboard')); ?>"
                       class="flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-medium transition-colors <?php echo e(request()->routeIs('dashboard') ? 'bg-surface text-main' : 'text-muted hover:text-main hover:bg-surface/50'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                        </svg>
                        Dashboard
                    </a>

                    <button @click="setupGuideOpen = true; mobileMenuOpen = false"
                            class="flex items-center gap-3 w-full px-4 py-3 rounded-xl text-sm font-medium text-muted hover:text-main hover:bg-surface/50 transition-colors text-left">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253" />
                        </svg>
                        Setup Guide
                    </button>

                    <?php if(auth()->check() && auth()->user()->isAdmin()): ?>
                    <a href="<?php echo e(route('admin.index')); ?>"
                       class="flex items-center gap-3 px-4 py-3 rounded-xl text-sm font-medium transition-colors <?php echo e(request()->routeIs('admin.*') ? 'bg-surface text-main' : 'text-muted hover:text-main hover:bg-surface/50'); ?>">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z" />
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        </svg>
                        Admin Panel
                    </a>
                    <?php endif; ?>

                    <?php if(auth()->check()): ?>
                    <div class="pt-4 mt-4 border-t border-subtle/50">
                        <div class="flex items-center justify-between px-4 py-2">
                            <div class="flex items-center gap-3">
                                <div class="w-8 h-8 rounded-lg bg-gradient-purple flex items-center justify-center text-white text-sm font-bold">
                                    <?php echo e(strtoupper(substr(auth()->user()->name, 0, 1))); ?>

                                </div>
                                <span class="text-sm font-medium text-secondary"><?php echo e(auth()->user()->name); ?></span>
                            </div>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="px-4 py-2 bg-surface hover:bg-danger/10 text-muted hover:text-danger rounded-lg text-sm font-medium transition-colors">
                                    Logout
                                </button>
                            </form>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </nav>
        </header>

        <!-- Flash Messages -->
        <?php if(session('success')): ?>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-6">
            <div class="animate-fade-in bg-success/10 border border-success/25 text-success px-5 py-4 rounded-xl flex items-center gap-3">
                <svg class="w-5 h-5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                </svg>
                <span class="text-sm font-medium"><?php echo e(session('success')); ?></span>
            </div>
        </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-6">
            <div class="animate-fade-in bg-danger/10 border border-danger/25 text-danger px-5 py-4 rounded-xl flex items-center gap-3">
                <svg class="w-5 h-5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                </svg>
                <span class="text-sm font-medium"><?php echo e(session('error')); ?></span>
            </div>
        </div>
        <?php endif; ?>

        <!-- Main Content -->
        <main class="flex-1">
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <!-- Setup Guide Modal -->
        <div x-show="setupGuideOpen"
             x-transition:enter="ease-out duration-200"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="ease-in duration-150"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             class="fixed inset-0 z-50 overflow-y-auto"
             style="display: none;"
             @keydown.escape.window="setupGuideOpen = false"
             x-cloak>
            <!-- Backdrop -->
            <div class="fixed inset-0 bg-black/80 backdrop-blur-sm" @click="setupGuideOpen = false"></div>

            <!-- Modal -->
            <div class="relative min-h-screen flex items-center justify-center p-4">
                <div x-transition:enter="ease-out duration-200"
                     x-transition:enter-start="opacity-0 scale-95"
                     x-transition:enter-end="opacity-100 scale-100"
                     x-transition:leave="ease-in duration-150"
                     x-transition:leave-start="opacity-100 scale-100"
                     x-transition:leave-end="opacity-0 scale-95"
                     class="relative bg-card rounded-2xl max-w-4xl w-full border border-subtle shadow-2xl max-h-[90vh] overflow-hidden flex flex-col">
                    <!-- Close Button -->
                    <button @click="setupGuideOpen = false"
                            class="absolute top-4 right-4 z-10 p-2 rounded-lg bg-surface hover:bg-surface-hover text-muted hover:text-main transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>

                    <!-- Content -->
                    <div class="p-8 overflow-y-auto">
                        <?php echo $__env->make('dashboard.partials.moderator-tutorial', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <footer class="mt-auto border-t border-subtle/50 bg-card/50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
                <!-- Footer Links -->
                <div class="flex flex-wrap justify-center gap-x-8 gap-y-3 mb-6">
                    <a href="<?php echo e(route('privacy-policy')); ?>" class="text-sm text-muted hover:text-accent-primary transition-colors">
                        Privacy Policy
                    </a>
                    <a href="<?php echo e(route('terms-of-service')); ?>" class="text-sm text-muted hover:text-accent-primary transition-colors">
                        Terms of Service
                    </a>
                    <a href="<?php echo e(route('contact')); ?>" class="text-sm text-muted hover:text-accent-primary transition-colors">
                        Contact
                    </a>
                    <a href="https://www.youtube.com/t/terms" target="_blank" rel="noopener noreferrer" class="text-sm text-muted hover:text-accent-primary transition-colors">
                        YouTube ToS
                    </a>
                </div>

                <!-- Copyright -->
                <div class="text-center space-y-2">
                    <p class="text-sm text-muted">
                        <?php echo e(date('Y')); ?> DAYBot. Made with <span class="text-danger">&#9829;</span> for YouTube creators.
                    </p>
                    <p class="text-xs text-dimmed">
                        <a href="https://DAYBot.tv" class="text-accent-primary hover:text-purple-400 transition-colors">DAYBot.tv</a>
                    </p>
                    <p class="text-xs text-dimmed">
                        By using DAYBot, you agree to the
                        <a href="https://www.youtube.com/t/terms" target="_blank" rel="noopener noreferrer" class="text-accent-primary hover:underline">YouTube Terms of Service</a>
                    </p>
                </div>
            </div>
        </footer>
    </div>

    <!-- Alpine.js x-cloak -->
    <style>
        [x-cloak] { display: none !important; }
    </style>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\daybot.tv\resources\views/layouts/app.blade.php ENDPATH**/ ?>