<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-6 lg:px-8 py-12">
    <div class="bg-card rounded-2xl border border-subtle p-8 md:p-12">
        <h1 class="text-4xl font-bold text-main mb-4">Contact Us</h1>
        <p class="text-sm text-muted mb-8">Get in touch with the DAYBot team</p>

        <div class="space-y-8">
            <!-- Contact Information -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-6">Contact Information</h2>

                <div class="grid md:grid-cols-2 gap-6">
                    <!-- Email -->
                    <div class="bg-surface rounded-xl p-6 border border-subtle hover:border-hover transition-colors">
                        <div class="flex items-start space-x-4">
                            <div class="w-12 h-12 rounded-lg bg-accent-primary/10 flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-accent-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-lg font-semibold text-main mb-2">Email Support</h3>
                                <p class="text-secondary text-sm mb-3">For general inquiries and support</p>
                                <a href="mailto:support@daybot.tv" class="text-accent-primary hover:text-accent-secondary font-medium">
                                    support@daybot.tv
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Website -->
                    <div class="bg-surface rounded-xl p-6 border border-subtle hover:border-hover transition-colors">
                        <div class="flex items-start space-x-4">
                            <div class="w-12 h-12 rounded-lg bg-accent-secondary/10 flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-accent-secondary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-lg font-semibold text-main mb-2">Website</h3>
                                <p class="text-secondary text-sm mb-3">Visit our official website</p>
                                <a href="https://daybot.tv" target="_blank" class="text-accent-primary hover:text-accent-secondary font-medium">
                                    daybot.tv
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Business Information -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-6">Business Information</h2>
                <div class="bg-surface rounded-xl p-6 border border-subtle">
                    <div class="space-y-4">
                        <div>
                            <p class="text-muted text-sm mb-1">Service Name</p>
                            <p class="text-main font-medium">DAYBot - YouTube Chat Bot</p>
                        </div>
                        <div>
                            <p class="text-muted text-sm mb-1">API Client Project Number</p>
                            <p class="text-main font-medium">462694888013</p>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Support Topics -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-6">How Can We Help?</h2>
                <div class="grid md:grid-cols-3 gap-4">
                    <div class="bg-surface rounded-lg p-5 border border-subtle">
                        <h3 class="text-main font-semibold mb-2">Technical Support</h3>
                        <p class="text-secondary text-sm">Bot not working, connection issues, or technical problems</p>
                    </div>
                    <div class="bg-surface rounded-lg p-5 border border-subtle">
                        <h3 class="text-main font-semibold mb-2">Account Issues</h3>
                        <p class="text-secondary text-sm">Login problems, password reset, or account deletion requests</p>
                    </div>
                    <div class="bg-surface rounded-lg p-5 border border-subtle">
                        <h3 class="text-main font-semibold mb-2">Privacy & Data</h3>
                        <p class="text-secondary text-sm">Data deletion requests, privacy concerns, or API access</p>
                    </div>
                </div>
            </section>

            <!-- Response Time -->
            <section>
                <div class="bg-accent-primary/10 border border-accent-primary/30 rounded-xl p-6">
                    <div class="flex items-start space-x-3">
                        <svg class="w-6 h-6 text-accent-primary flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd" />
                        </svg>
                        <div>
                            <h3 class="text-lg font-semibold text-main mb-2">Response Time</h3>
                            <p class="text-secondary text-sm">
                                We aim to respond to all inquiries within 24-48 hours during business days. For urgent issues, please mention "URGENT" in your email subject line.
                            </p>
                        </div>
                    </div>
                </div>
            </section>

            <!-- Quick Links -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-6">Quick Links</h2>
                <div class="flex flex-wrap gap-3">
                    <a href="<?php echo e(route('privacy-policy')); ?>" class="px-4 py-2 bg-surface hover:bg-surface-hover rounded-lg text-secondary text-sm font-medium border border-subtle transition-colors">
                        Privacy Policy
                    </a>
                    <a href="<?php echo e(route('terms-of-service')); ?>" class="px-4 py-2 bg-surface hover:bg-surface-hover rounded-lg text-secondary text-sm font-medium border border-subtle transition-colors">
                        Terms of Service
                    </a>
                    <a href="https://www.youtube.com/t/terms" target="_blank" class="px-4 py-2 bg-surface hover:bg-surface-hover rounded-lg text-secondary text-sm font-medium border border-subtle transition-colors">
                        YouTube Terms of Service
                    </a>
                    <a href="https://www.google.com/policies/privacy" target="_blank" class="px-4 py-2 bg-surface hover:bg-surface-hover rounded-lg text-secondary text-sm font-medium border border-subtle transition-colors">
                        Google Privacy Policy
                    </a>
                </div>
            </section>

            <!-- Back to Dashboard -->
            <div class="pt-8 border-t border-subtle">
                <a href="<?php echo e(route('dashboard')); ?>" class="inline-flex items-center text-accent-primary hover:text-accent-secondary">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                    Back to Dashboard
                </a>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\daybot.tv\resources\views/pages/contact.blade.php ENDPATH**/ ?>