<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-6 lg:px-8 py-12">
    <div class="bg-card rounded-2xl border border-subtle p-8 md:p-12">
        <h1 class="text-4xl font-bold text-main mb-4">Privacy Policy</h1>
        <p class="text-sm text-muted mb-8">Last Updated: <?php echo e(date('F d, Y')); ?></p>

        <div class="prose prose-invert max-w-none space-y-8">
            <!-- Introduction -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">1. Introduction</h2>
                <p class="text-secondary leading-relaxed">
                    Welcome to Daybot ("we," "our," or "us"). This Privacy Policy explains how we collect, use, store, and share information when you use our YouTube live chat automation service. By using Daybot, you agree to the terms outlined in this policy.
                </p>
                <p class="text-secondary leading-relaxed mt-4">
                    Daybot uses <strong>YouTube API Services</strong> to provide automated chat responses and engagement features for YouTube live streams. Your use of our service is also governed by the <a href="https://www.google.com/policies/privacy" target="_blank" class="text-accent-primary hover:underline">Google Privacy Policy</a> and the <a href="https://developers.google.com/terms/api-services-user-data-policy" target="_blank" class="text-accent-primary hover:underline">Google API Services User Data Policy</a>, including the Limited Use requirements.
                </p>
            </section>

            <!-- Google API Services User Data Policy -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">2. Google API Services User Data Policy Compliance</h2>
                <p class="text-secondary leading-relaxed mb-3">
                    Daybot's use and transfer of information received from Google APIs adheres to the <a href="https://developers.google.com/terms/api-services-user-data-policy#additional_requirements_for_specific_api_scopes" target="_blank" class="text-accent-primary hover:underline">Google API Services User Data Policy</a>, including the Limited Use requirements.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">2.1 Limited Use Requirements</h3>
                <p class="text-secondary leading-relaxed mb-3">
                    We access your YouTube data <strong>exclusively</strong> to provide and improve the Daybot live chat automation service. Specifically:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>We <strong>DO NOT</strong> use your YouTube data to serve advertisements</li>
                    <li>We <strong>DO NOT</strong> sell your YouTube data to third parties</li>
                    <li>We <strong>DO NOT</strong> use your YouTube data for purposes unrelated to providing Daybot functionality</li>
                    <li>We <strong>DO NOT</strong> allow humans to read your data unless:
                        <ul class="list-disc list-inside ml-6 mt-2">
                            <li>You give explicit permission</li>
                            <li>It's necessary for security purposes (e.g., investigating abuse)</li>
                            <li>It's required to comply with applicable law</li>
                            <li>Our use is limited to internal operations and necessary for maintaining or improving Daybot</li>
                        </ul>
                    </li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">2.2 Transparency and User Control</h3>
                <p class="text-secondary leading-relaxed">
                    You maintain full control over your YouTube data. You can revoke Daybot's access to your YouTube data at any time through your <a href="https://myaccount.google.com/permissions" target="_blank" class="text-accent-primary hover:underline">Google Account Permissions page</a>. Once revoked, Daybot will immediately lose access to your YouTube data and will no longer function for your channel.
                </p>
            </section>

            <!-- Information We Collect -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">3. Information We Collect</h2>
                <p class="text-secondary leading-relaxed mb-3">When you use Daybot, we access, collect, and store the following types of information:</p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">3.1 YouTube Data (via YouTube API Services)</h3>
                <p class="text-secondary leading-relaxed mb-3">
                    We request OAuth access to your YouTube account to provide live chat automation. The specific data we access includes:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li><strong>Channel Information:</strong> Your YouTube channel name, channel ID, channel handle, and profile picture</li>
                    <li><strong>Live Chat Messages:</strong> Messages posted by viewers in your YouTube live stream chat (read-only access)</li>
                    <li><strong>Chat Participant Information:</strong> Usernames and user IDs of chat participants</li>
                    <li><strong>Live Broadcast Details:</strong> Active live stream ID and associated live chat ID</li>
                    <li><strong>OAuth Access Tokens:</strong> Secure tokens that allow Daybot to perform authorized actions on your behalf (stored encrypted)</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-3">
                    <strong>Why we need this data:</strong> To monitor your live chat for messages, respond automatically with AI or custom commands, moderate inappropriate content, and execute chat management tasks you configure.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">3.2 Account Information</h3>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li><strong>Email address:</strong> For account creation, authentication, and important service notifications</li>
                    <li><strong>Name:</strong> As provided during registration (used for account identification)</li>
                    <li><strong>Password:</strong> Encrypted using bcrypt hashing and stored securely in our database</li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">3.3 Bot Configuration Data</h3>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>Custom commands and automated responses you create</li>
                    <li>Banned keywords and moderation rules</li>
                    <li>Timer messages and greeting configurations</li>
                    <li>Bot settings (language, response style, rate limits)</li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">3.4 Usage and Analytics Data</h3>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>Chat messages processed by the bot (for analytics and performance monitoring)</li>
                    <li>Bot activity logs (message counts, command usage, moderation actions)</li>
                    <li>Login times and session information</li>
                    <li>Error logs and debugging information</li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">3.5 Cookies and Similar Technologies</h3>
                <p class="text-secondary leading-relaxed">
                    We store, access, and collect information directly or indirectly on or from your devices by placing, accessing, or recognizing cookies and similar technologies on your devices or browsers. These include:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4 mt-3">
                    <li><strong>Session Cookies:</strong> To keep you logged in and maintain your session state</li>
                    <li><strong>CSRF Tokens:</strong> For security purposes to prevent cross-site request forgery attacks</li>
                    <li><strong>Authentication Tokens:</strong> To manage your Google OAuth connection securely</li>
                    <li><strong>Preference Cookies:</strong> To remember your bot settings and dashboard preferences</li>
                </ul>
            </section>

            <!-- How We Use Your Information -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">4. How We Use Your Information</h2>
                <p class="text-secondary leading-relaxed mb-3">We use the collected information exclusively for the following purposes:</p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li><strong>Service Delivery:</strong> To operate the chatbot, monitor your live chat, and respond to messages according to your configuration</li>
                    <li><strong>Authentication:</strong> To verify your identity and manage your account securely</li>
                    <li><strong>Bot Configuration:</strong> To store and execute your custom commands, automated responses, and moderation rules</li>
                    <li><strong>AI Response Generation:</strong> To send chat messages to OpenAI API for intelligent response generation (if enabled)</li>
                    <li><strong>Content Moderation:</strong> To detect and handle inappropriate content, spam, and banned keywords</li>
                    <li><strong>Analytics and Monitoring:</strong> To track bot performance, message statistics, and service health</li>
                    <li><strong>Service Improvement:</strong> To identify bugs, improve features, and enhance user experience</li>
                    <li><strong>Communication:</strong> To send you important updates about your account, service changes, or security alerts</li>
                    <li><strong>Compliance:</strong> To comply with legal obligations and enforce our Terms of Service</li>
                </ul>
            </section>

            <!-- How We Process and Share Information -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">5. How We Process and Share Your Information</h2>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">5.1 Internal Processing</h3>
                <p class="text-secondary leading-relaxed">
                    Your data is processed internally within our secure application servers hosted on trusted infrastructure. We use your YouTube data solely to provide the chatbot functionality you have configured. Access to your data is restricted to essential system processes and authorized personnel only when necessary for security or support purposes.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">5.2 Third-Party Services</h3>
                <p class="text-secondary leading-relaxed mb-3">We share limited information with the following third-party services to provide Daybot functionality:</p>
                <ul class="list-disc list-inside text-secondary space-y-3 ml-4">
                    <li>
                        <strong>Google/YouTube API Services:</strong> We interact with YouTube API Services to read live chat messages and post bot responses on your behalf. This data sharing is governed by the <a href="https://www.youtube.com/t/terms" target="_blank" class="text-accent-primary hover:underline">YouTube Terms of Service</a> and <a href="https://www.google.com/policies/privacy" target="_blank" class="text-accent-primary hover:underline">Google Privacy Policy</a>.
                    </li>
                    <li>
                        <strong>OpenAI API:</strong> Chat messages may be sent to OpenAI's language models (GPT-4, GPT-3.5) to generate intelligent responses if you enable AI features. OpenAI's use of your data is governed by their <a href="https://openai.com/policies/privacy-policy" target="_blank" class="text-accent-primary hover:underline">Privacy Policy</a> and <a href="https://openai.com/policies/terms-of-use" target="_blank" class="text-accent-primary hover:underline">Terms of Use</a>. OpenAI does not use API data to train their models.
                    </li>
                </ul>
                <p class="text-secondary leading-relaxed mt-3">
                    <strong>Note:</strong> You can disable AI features at any time to prevent chat messages from being sent to OpenAI.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">5.3 Data We DO NOT Share</h3>
                <div class="bg-green-500/10 border border-green-500/30 rounded-lg p-4 mt-3">
                    <p class="text-secondary leading-relaxed">
                        <strong class="text-green-400">We are committed to protecting your privacy:</strong>
                    </p>
                    <ul class="list-disc list-inside text-secondary space-y-2 ml-4 mt-2">
                        <li>We <strong>DO NOT</strong> sell, rent, or trade your personal information</li>
                        <li>We <strong>DO NOT</strong> share your data with advertisers or marketing companies</li>
                        <li>We <strong>DO NOT</strong> use your YouTube data for advertising purposes</li>
                        <li>We <strong>DO NOT</strong> transfer your data to third parties except as explicitly stated in this policy</li>
                        <li>We <strong>DO NOT</strong> allow unauthorized human access to your data</li>
                    </ul>
                </div>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">5.4 Legal Disclosure</h3>
                <p class="text-secondary leading-relaxed">
                    We may disclose your information if required by law, court order, or government regulation, or if we believe disclosure is necessary to protect our rights, your safety, or the safety of others.
                </p>
            </section>

            <!-- Data Storage and Security -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">6. Data Storage and Security</h2>
                <p class="text-secondary leading-relaxed mb-3">
                    We take data security seriously and implement industry-standard security measures to protect your information:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li><strong>Encryption:</strong> All passwords are encrypted using bcrypt hashing algorithm</li>
                    <li><strong>Secure Transmission:</strong> All data transmission uses HTTPS/TLS encryption</li>
                    <li><strong>OAuth 2.0 Security:</strong> YouTube access tokens are stored encrypted and transmitted securely</li>
                    <li><strong>Access Control:</strong> Database access is restricted to authorized systems and personnel only</li>
                    <li><strong>Regular Updates:</strong> We perform regular security audits and apply security patches promptly</li>
                    <li><strong>Session Security:</strong> User sessions expire after inactivity and use secure cookie flags</li>
                </ul>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">6.1 Data Retention</h3>
                <p class="text-secondary leading-relaxed mb-3">
                    We retain your data for as long as your account is active or as needed to provide services:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li><strong>Account Data:</strong> Retained while your account is active</li>
                    <li><strong>YouTube OAuth Tokens:</strong> Retained until you disconnect your channel or revoke access</li>
                    <li><strong>Chat Logs:</strong> Stored for up to 90 days for analytics purposes, then automatically deleted</li>
                    <li><strong>Bot Configuration:</strong> Retained until you delete the configuration or close your account</li>
                    <li><strong>Audit Logs:</strong> Security-related logs retained for up to 1 year for compliance purposes</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-3">
                    Upon account deletion, all personal data will be permanently removed within 30 days, except where retention is required by law.
                </p>
            </section>

            <!-- Your Data Rights -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">7. Your Data Rights</h2>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">7.1 Right to Access</h3>
                <p class="text-secondary leading-relaxed">
                    You can view and download your data through your Daybot dashboard at any time. This includes your account information, bot configuration, and analytics data.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">7.2 Right to Correction</h3>
                <p class="text-secondary leading-relaxed">
                    You can update your account information, email address, and bot configuration at any time through your dashboard settings.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">7.3 Right to Deletion</h3>
                <p class="text-secondary leading-relaxed mb-3">
                    You have the right to delete your data at any time:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li><strong>Disconnect YouTube Channel:</strong> You can disconnect your YouTube channel from Daybot through your dashboard, which stops all data collection</li>
                    <li><strong>Delete Account:</strong> Contact us at <a href="mailto:support@daybot.tv" class="text-accent-primary hover:underline">support@daybot.tv</a> to request full account deletion</li>
                    <li><strong>Revoke API Access:</strong> Visit your <a href="https://myaccount.google.com/permissions" target="_blank" class="text-accent-primary hover:underline">Google Account Permissions page</a> and remove Daybot's access to your YouTube data</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-4">
                    Upon account deletion, we will permanently remove your personal information and YouTube data within 30 days.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">7.4 Right to Data Portability</h3>
                <p class="text-secondary leading-relaxed">
                    You can export your bot configuration and analytics data in JSON format through your dashboard.
                </p>

                <h3 class="text-xl font-semibold text-main mb-3 mt-6">7.5 Right to Withdraw Consent</h3>
                <p class="text-secondary leading-relaxed">
                    You can withdraw consent for data processing at any time by disconnecting your YouTube channel or deleting your account. This will immediately stop all data collection and processing.
                </p>
            </section>

            <!-- YouTube API Services -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">8. YouTube API Services</h2>
                <p class="text-secondary leading-relaxed mb-3">
                    Daybot uses YouTube API Services to provide its core functionality. Your use of our service is subject to:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li><a href="https://www.youtube.com/t/terms" target="_blank" class="text-accent-primary hover:underline">YouTube Terms of Service</a></li>
                    <li><a href="https://www.google.com/policies/privacy" target="_blank" class="text-accent-primary hover:underline">Google Privacy Policy</a></li>
                    <li><a href="https://developers.google.com/terms/api-services-user-data-policy" target="_blank" class="text-accent-primary hover:underline">Google API Services User Data Policy</a></li>
                </ul>
                <p class="text-secondary leading-relaxed mt-4">
                    By using Daybot, you acknowledge that YouTube data accessed through Daybot is governed by these policies in addition to this Privacy Policy.
                </p>
            </section>

            <!-- International Data Transfers -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">9. International Data Transfers</h2>
                <p class="text-secondary leading-relaxed">
                    Your data may be transferred to and processed in countries other than your country of residence. We ensure appropriate safeguards are in place to protect your data in accordance with this Privacy Policy and applicable data protection laws.
                </p>
            </section>

            <!-- GDPR Compliance (for EU users) -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">10. GDPR Compliance (European Users)</h2>
                <p class="text-secondary leading-relaxed mb-3">
                    If you are located in the European Economic Area (EEA), you have additional rights under the General Data Protection Regulation (GDPR):
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4">
                    <li>Right to access your personal data</li>
                    <li>Right to rectification of inaccurate data</li>
                    <li>Right to erasure ("right to be forgotten")</li>
                    <li>Right to restrict processing</li>
                    <li>Right to data portability</li>
                    <li>Right to object to processing</li>
                    <li>Right to withdraw consent at any time</li>
                    <li>Right to lodge a complaint with a supervisory authority</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-3">
                    <strong>Legal Basis for Processing:</strong> We process your data based on your consent (when you authorize YouTube API access) and our legitimate interest in providing the Daybot service.
                </p>
            </section>

            <!-- Children's Privacy -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">11. Children's Privacy</h2>
                <p class="text-secondary leading-relaxed">
                    Our service is not intended for children under 13 years of age (or the minimum age required in your country). We do not knowingly collect personal information from children under 13. If you believe we have collected information from a child under 13, please contact us immediately at <a href="mailto:support@daybot.tv" class="text-accent-primary hover:underline">support@daybot.tv</a>.
                </p>
            </section>

            <!-- Changes to This Policy -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">12. Changes to This Privacy Policy</h2>
                <p class="text-secondary leading-relaxed">
                    We may update this Privacy Policy from time to time to reflect changes in our practices, technology, legal requirements, or other factors. We will notify you of any material changes by:
                </p>
                <ul class="list-disc list-inside text-secondary space-y-2 ml-4 mt-3">
                    <li>Posting the updated policy on this page with a new "Last Updated" date</li>
                    <li>Sending an email notification to your registered email address</li>
                    <li>Displaying a prominent notice on your dashboard</li>
                </ul>
                <p class="text-secondary leading-relaxed mt-3">
                    Your continued use of Daybot after policy changes constitutes acceptance of the updated Privacy Policy.
                </p>
            </section>

            <!-- Contact Information -->
            <section>
                <h2 class="text-2xl font-semibold text-main mb-4">13. Contact Us</h2>
                <p class="text-secondary leading-relaxed mb-3">
                    If you have any questions, concerns, or requests regarding this Privacy Policy or our data practices, please contact us:
                </p>
                <div class="bg-surface rounded-lg p-6 mt-4">
                    <p class="text-secondary"><strong class="text-main">Email:</strong> <a href="mailto:support@daybot.tv" class="text-accent-primary hover:underline">support@daybot.tv</a></p>
                    <p class="text-secondary mt-2"><strong class="text-main">Website:</strong> <a href="https://daybot.tv" target="_blank" class="text-accent-primary hover:underline">https://daybot.tv</a></p>
                    <p class="text-secondary mt-2"><strong class="text-main">Official Domain:</strong> daybot.tv</p>
                </div>
                <p class="text-secondary leading-relaxed mt-4">
                    We will respond to your inquiry within 30 days.
                </p>
            </section>

            <!-- Back to Home -->
            <div class="pt-8 border-t border-subtle mt-12">
                <a href="<?php echo e(route('welcome')); ?>" class="inline-flex items-center text-accent-primary hover:text-accent-secondary mr-6">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                    </svg>
                    Back to Home
                </a>
                <?php if(auth()->guard()->check()): ?>
                <a href="<?php echo e(route('dashboard')); ?>" class="inline-flex items-center text-accent-primary hover:text-accent-secondary">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                    </svg>
                    Back to Dashboard
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\daybot.tv\resources\views/pages/privacy-policy.blade.php ENDPATH**/ ?>