<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="mb-8 flex flex-col sm:flex-row sm:justify-between sm:items-center gap-4">
        <div>
            <h2 class="text-3xl font-bold text-main">Banned Keywords & Moderation</h2>
            <p class="mt-2 text-muted">Manage banned words and spam protection for <span class="text-accent-primary"><?php echo e($tenant->channel_title); ?></span></p>
        </div>
        <a href="<?php echo e(route('dashboard')); ?>" class="inline-flex items-center px-4 py-2 bg-surface hover:bg-surface-hover text-secondary border border-subtle rounded-lg font-medium transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Dashboard
        </a>
    </div>

    <!-- Spam Protection Settings -->
    <div class="bg-card border border-subtle rounded-2xl p-6 shadow-sm mb-6">
        <div class="flex items-center mb-4">
            <svg class="w-6 h-6 text-accent-secondary mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
            </svg>
            <h3 class="text-xl font-semibold text-main">Spam Protection</h3>
        </div>

        <form method="POST" action="<?php echo e(route('tenant.spam-protection.update', $tenant)); ?>" class="space-y-4">
            <?php echo csrf_field(); ?>

            <div class="flex items-center justify-between p-4 bg-surface/50 border border-subtle rounded-xl">
                <div>
                    <p class="text-sm font-medium text-main">Enable Spam Protection</p>
                    <p class="text-xs text-muted mt-1">Automatically timeout users who spam the same message</p>
                </div>
                <label class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" name="spam_protection_enabled" value="1" <?php echo e($tenant->spam_protection_enabled ? 'checked' : ''); ?> class="sr-only peer">
                    <div class="w-11 h-6 bg-surface border border-subtle rounded-full peer peer-checked:bg-accent-primary peer-checked:border-accent-primary transition-colors"></div>
                    <div class="absolute left-1 top-1 w-4 h-4 bg-white rounded-full transition-transform peer-checked:translate-x-5"></div>
                </label>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-secondary mb-2">Message Limit</label>
                    <input type="number" name="spam_message_limit" value="<?php echo e($tenant->spam_message_limit ?? 3); ?>" min="2" max="10" class="w-full px-4 py-2 bg-surface border border-subtle rounded-lg text-main focus:outline-none focus:ring-2 focus:ring-accent-primary/50">
                    <p class="text-xs text-muted mt-1">How many repeated messages</p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-secondary mb-2">Time Window (seconds)</label>
                    <input type="number" name="spam_time_window" value="<?php echo e($tenant->spam_time_window ?? 30); ?>" min="10" max="120" class="w-full px-4 py-2 bg-surface border border-subtle rounded-lg text-main focus:outline-none focus:ring-2 focus:ring-accent-primary/50">
                    <p class="text-xs text-muted mt-1">Within this time period</p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-secondary mb-2">Timeout Duration (seconds)</label>
                    <input type="number" name="spam_timeout_duration" value="<?php echo e($tenant->spam_timeout_duration ?? 300); ?>" min="60" max="86400" class="w-full px-4 py-2 bg-surface border border-subtle rounded-lg text-main focus:outline-none focus:ring-2 focus:ring-accent-primary/50">
                    <p class="text-xs text-muted mt-1"><?php echo e(round(($tenant->spam_timeout_duration ?? 300) / 60)); ?> minutes</p>
                </div>
            </div>

            <button type="submit" class="inline-flex items-center px-4 py-2 bg-accent-primary hover:bg-accent-primary-hover text-white rounded-lg font-medium shadow-sm transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                </svg>
                Save Spam Settings
            </button>
        </form>
    </div>

    <!-- Add Banned Keyword Form -->
    <div class="bg-card border border-subtle rounded-2xl p-6 shadow-sm mb-6">
        <div class="flex items-center mb-4">
            <svg class="w-6 h-6 text-warning mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
            </svg>
            <h3 class="text-xl font-semibold text-main">Add Banned Keyword</h3>
        </div>

        <form method="POST" action="<?php echo e(route('tenant.banned-keywords.store', $tenant)); ?>" class="space-y-4">
            <?php echo csrf_field(); ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-secondary mb-2">Keyword or Phrase</label>
                    <input type="text" name="keyword" required class="w-full px-4 py-2 bg-surface border border-subtle rounded-lg text-main placeholder:text-muted focus:outline-none focus:ring-2 focus:ring-warning/50" placeholder="e.g., badword, spam phrase">
                    <?php $__errorArgs = ['keyword'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-danger"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label class="block text-sm font-medium text-secondary mb-2">Timeout Duration</label>
                    <select name="timeout_duration" class="w-full px-4 py-2 bg-surface border border-subtle rounded-lg text-main focus:outline-none focus:ring-2 focus:ring-warning/50">
                        <option value="60">1 minute</option>
                        <option value="300" selected>5 minutes</option>
                        <option value="600">10 minutes</option>
                        <option value="1800">30 minutes</option>
                        <option value="3600">1 hour</option>
                        <option value="86400">24 hours</option>
                    </select>
                    <p class="text-xs text-muted mt-1">Timeout duration after second violation</p>
                </div>
            </div>

            <button type="submit" class="inline-flex items-center px-5 py-2 bg-gradient-to-r from-warning to-amber-500 hover:from-amber-500 hover:to-warning text-white rounded-lg font-medium shadow-lg transition-all">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                </svg>
                Add Banned Keyword
            </button>
        </form>
    </div>

    <!-- Banned Keywords List -->
    <div class="bg-card border border-subtle rounded-2xl shadow-sm overflow-hidden">
        <div class="p-6 border-b border-subtle">
            <h3 class="text-xl font-semibold text-main">Banned Keywords List</h3>
            <p class="text-sm text-muted mt-1">Users get 1 warning, then timeout on second violation (24hr window)</p>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-subtle">
                <thead class="bg-surface/50">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-dimmed uppercase">Keyword</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-dimmed uppercase">Timeout Duration</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-dimmed uppercase">Status</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-dimmed uppercase">Created</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-dimmed uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-subtle">
                    <?php $__empty_1 = true; $__currentLoopData = $keywords; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keyword): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-surface/30 transition-colors">
                        <td class="px-6 py-4">
                            <span class="text-sm font-mono font-semibold text-warning"><?php echo e($keyword->keyword); ?></span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-sm text-secondary"><?php echo e(round($keyword->timeout_duration / 60)); ?> minutes</span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($keyword->is_enabled ? 'bg-success/10 text-success border border-success/20' : 'bg-surface text-muted border border-subtle'); ?>">
                                <?php echo e($keyword->is_enabled ? 'Active' : 'Disabled'); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-sm text-muted"><?php echo e($keyword->created_at->diffForHumans()); ?></span>
                        </td>
                        <td class="px-6 py-4 text-right space-x-2">
                            <form method="POST" action="<?php echo e(route('tenant.banned-keywords.toggle', [$tenant, $keyword])); ?>" class="inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="text-accent-secondary hover:text-accent-primary transition-colors" title="<?php echo e($keyword->is_enabled ? 'Disable' : 'Enable'); ?>">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <?php if($keyword->is_enabled): ?>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636" />
                                        <?php else: ?>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                        <?php endif; ?>
                                    </svg>
                                </button>
                            </form>

                            <form method="POST" action="<?php echo e(route('tenant.banned-keywords.destroy', [$tenant, $keyword])); ?>" class="inline" onsubmit="return confirm('Delete this banned keyword?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-danger hover:text-danger-hover transition-colors" title="Delete">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                    </svg>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center">
                            <svg class="w-12 h-12 text-muted mx-auto mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                            </svg>
                            <p class="text-muted">No banned keywords yet. Add one to get started!</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Active Warnings -->
    <?php if($warnings->isNotEmpty()): ?>
    <div class="mt-6 bg-card border border-subtle rounded-2xl shadow-sm overflow-hidden">
        <div class="p-6 border-b border-subtle">
            <h3 class="text-xl font-semibold text-main">Active Warnings (Last 24 Hours)</h3>
            <p class="text-sm text-muted mt-1">Users with recent violations</p>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-subtle">
                <thead class="bg-surface/50">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-dimmed uppercase">User</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-dimmed uppercase">Violation</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-dimmed uppercase">Warning Count</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-dimmed uppercase">Last Violation</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-dimmed uppercase">Expires</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-subtle">
                    <?php $__currentLoopData = $warnings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warning): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-surface/30 transition-colors">
                        <td class="px-6 py-4">
                            <span class="text-sm font-medium text-main"><?php echo e($warning->user_name); ?></span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-sm text-secondary"><?php echo e($warning->violation_details); ?></span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($warning->warning_count >= 2 ? 'bg-danger/10 text-danger border border-danger/20' : 'bg-warning/10 text-warning border border-warning/20'); ?>">
                                <?php echo e($warning->warning_count); ?> warning<?php echo e($warning->warning_count > 1 ? 's' : ''); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-sm text-muted"><?php echo e($warning->last_violation_at->diffForHumans()); ?></span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-sm text-muted"><?php echo e($warning->expires_at->diffForHumans()); ?></span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\daybot.tv\resources\views/tenant/banned-keywords/index.blade.php ENDPATH**/ ?>