<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Header -->
    <div class="mb-8">
        <a href="<?php echo e(route('tenant.timers.index', $tenant)); ?>" class="inline-flex items-center text-gray-400 hover:text-gray-300 mb-4 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Timers
        </a>
        <h2 class="text-3xl font-bold text-white">Create Timer</h2>
        <p class="mt-2 text-gray-400">Add a new automated timer for <span class="text-indigo-400"><?php echo e($tenant->channel_title); ?></span></p>
    </div>

    <!-- Form -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl p-6 sm:p-8">
        <form method="POST" action="<?php echo e(route('tenant.timers.store', $tenant)); ?>" class="space-y-6">
            <?php echo csrf_field(); ?>

            <!-- Timer Name -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-300 mb-2">
                    Timer Name <span class="text-red-400">*</span>
                </label>
                <input
                    type="text"
                    id="name"
                    name="name"
                    required
                    value="<?php echo e(old('name')); ?>"
                    placeholder="Discord Reminder"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all"
                >
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <p class="mt-1 text-xs text-gray-500">A friendly name to identify this timer</p>
            </div>

            <!-- Message -->
            <div>
                <label for="message" class="block text-sm font-medium text-gray-300 mb-2">
                    Message <span class="text-red-400">*</span>
                </label>
                <textarea
                    id="message"
                    name="message"
                    required
                    rows="4"
                    placeholder="Join our Discord server: https://discord.gg/example"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all resize-y"
                ><?php echo e(old('message')); ?></textarea>
                <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <p class="mt-1 text-xs text-gray-500">The message that will be sent automatically</p>
            </div>

            <!-- Interval -->
            <div>
                <label for="interval_min" class="block text-sm font-medium text-gray-300 mb-2">
                    Interval (minutes) <span class="text-red-400">*</span>
                </label>
                <input
                    type="number"
                    id="interval_min"
                    name="interval_min"
                    required
                    min="1"
                    max="1440"
                    value="<?php echo e(old('interval_min', 10)); ?>"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all"
                >
                <?php $__errorArgs = ['interval_min'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <p class="mt-1 text-xs text-gray-500">How often this message should be sent (1-1440 minutes)</p>
            </div>

            <!-- Chat Activity Window -->
            <div>
                <label for="chat_activity_window_min" class="block text-sm font-medium text-gray-300 mb-2">
                    Chat Activity Window (minutes) <span class="text-red-400">*</span>
                </label>
                <input
                    type="number"
                    id="chat_activity_window_min"
                    name="chat_activity_window_min"
                    required
                    min="1"
                    max="60"
                    value="<?php echo e(old('chat_activity_window_min', 10)); ?>"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all"
                >
                <?php $__errorArgs = ['chat_activity_window_min'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-400"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <p class="mt-1 text-xs text-gray-500">Minimum chat activity required before timer fires (1-60 minutes)</p>
            </div>

            <!-- Enabled -->
            <div class="flex items-center">
                <input
                    type="checkbox"
                    id="is_enabled"
                    name="is_enabled"
                    value="1"
                    <?php echo e(old('is_enabled', true) ? 'checked' : ''); ?>

                    class="w-4 h-4 text-indigo-600 bg-gray-700 border-gray-600 rounded focus:ring-2 focus:ring-indigo-500"
                >
                <label for="is_enabled" class="ml-3 text-sm font-medium text-gray-300">
                    Enable this timer
                </label>
            </div>

            <!-- Submit -->
            <div class="flex justify-end space-x-3 pt-4">
                <a
                    href="<?php echo e(route('tenant.timers.index', $tenant)); ?>"
                    class="px-6 py-3 bg-gray-700 hover:bg-gray-600 text-gray-300 rounded-lg font-medium transition-colors"
                >
                    Cancel
                </a>
                <button
                    type="submit"
                    class="px-6 py-3 bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-500 hover:to-purple-500 text-white rounded-lg font-medium shadow-lg transform hover:scale-105 transition-all duration-200"
                >
                    Create Timer
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\daybot.tv\resources\views/tenant/timers/create.blade.php ENDPATH**/ ?>