<?php

namespace App\Http\Requests\Timer;

use Illuminate\Foundation\Http\FormRequest;

class UpdateTimerRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:100'],
            'message' => ['required', 'string', 'max:500'],
            'interval_min' => ['required', 'integer', 'min:1', 'max:1440'],
            'chat_activity_window_min' => ['required', 'integer', 'min:1', 'max:60'],
            'is_enabled' => ['boolean'],
        ];
    }
}
