<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Timer extends Model
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'name',
        'message',
        'interval_min',
        'chat_activity_window_min',
        'is_enabled',
        'last_fired_at',
        'next_fire_at',
    ];

    protected function casts(): array
    {
        return [
            'is_enabled' => 'boolean',
            'last_fired_at' => 'datetime',
            'next_fire_at' => 'datetime',
        ];
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function shouldFire(): bool
    {
        if (!$this->is_enabled) {
            return false;
        }

        if (!$this->next_fire_at) {
            return true;
        }

        return now()->isAfter($this->next_fire_at);
    }

    public function markFired(): void
    {
        $randomOffset = rand(-10, 10); // ±10% randomization
        $nextInterval = $this->interval_min + ($this->interval_min * $randomOffset / 100);

        $this->update([
            'last_fired_at' => now(),
            'next_fire_at' => now()->addMinutes($nextInterval),
        ]);
    }
}
