<?php

namespace Database\Factories;

use App\Models\Tenant;
use Illuminate\Database\Eloquent\Factories\Factory;

class CommandFactory extends Factory
{
    public function definition(): array
    {
        return [
            'tenant_id' => Tenant::factory(),
            'name' => fake()->word(),
            'response' => fake()->sentence(),
            'cooldown_sec' => fake()->numberBetween(5, 30),
            'required_role' => fake()->randomElement(['owner', 'admin', 'mod', 'trusted', 'viewer']),
            'is_enabled' => true,
            'use_count' => 0,
        ];
    }
}
