<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Header -->
    <div class="mb-8 flex flex-col sm:flex-row sm:justify-between sm:items-center gap-4">
        <div>
            <h2 class="text-3xl font-bold text-white">Timers</h2>
            <p class="mt-2 text-gray-400">Manage automated timed messages for <span class="text-indigo-400"><?php echo e($tenant->channel_title); ?></span></p>
        </div>
        <div class="flex flex-wrap gap-3">
            <a href="<?php echo e(route('dashboard')); ?>" class="inline-flex items-center px-4 py-2 bg-gray-700 hover:bg-gray-600 text-gray-300 rounded-lg font-medium transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
                Back
            </a>
            <a href="<?php echo e(route('tenant.timers.create', $tenant)); ?>" class="inline-flex items-center px-5 py-2 bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-500 hover:to-purple-500 text-white rounded-lg font-medium shadow-lg transform hover:scale-105 transition-all duration-200">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                </svg>
                Add Timer
            </a>
        </div>
    </div>

    <!-- Timers Table (Desktop) -->
    <div class="hidden lg:block bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800/50">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Name</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Message</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Interval</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-gray-300 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $timers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-800/30 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm font-semibold text-white"><?php echo e($timer->name); ?></span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-sm text-gray-300"><?php echo e(\Str::limit($timer->message, 60)); ?></span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-400"><?php echo e($timer->interval_minutes); ?> min</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($timer->is_enabled ? 'bg-green-500/20 text-green-400 border border-green-500/30' : 'bg-gray-500/20 text-gray-400 border border-gray-500/30'); ?>">
                                <?php echo e($timer->is_enabled ? 'Enabled' : 'Disabled'); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-3">
                            <a href="<?php echo e(route('tenant.timers.edit', [$tenant, $timer])); ?>" class="text-indigo-400 hover:text-indigo-300 transition-colors">Edit</a>
                            <form method="POST" action="<?php echo e(route('tenant.timers.destroy', [$tenant, $timer])); ?>" class="inline" onsubmit="return confirm('Delete this timer?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-400 hover:text-red-300 transition-colors">Delete</button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center">
                            <svg class="mx-auto h-12 w-12 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                            <h3 class="mt-2 text-sm font-medium text-gray-400">No timers yet</h3>
                            <p class="mt-1 text-sm text-gray-500">Get started by creating your first automated timer.</p>
                            <div class="mt-6">
                                <a href="<?php echo e(route('tenant.timers.create', $tenant)); ?>" class="inline-flex items-center px-4 py-2 bg-indigo-600 hover:bg-indigo-500 text-white rounded-lg font-medium shadow-lg transition-colors">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                                    </svg>
                                    Create Timer
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Timers Cards (Mobile) -->
    <div class="lg:hidden space-y-4">
        <?php $__empty_1 = true; $__currentLoopData = $timers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl p-5 shadow-lg">
            <div class="flex items-start justify-between mb-3">
                <div class="flex-1">
                    <span class="text-base font-semibold text-white"><?php echo e($timer->name); ?></span>
                    <p class="text-sm text-gray-300 mt-1"><?php echo e(\Str::limit($timer->message, 80)); ?></p>
                </div>
                <span class="px-3 py-1 text-xs font-semibold rounded-full <?php echo e($timer->is_enabled ? 'bg-green-500/20 text-green-400 border border-green-500/30' : 'bg-gray-500/20 text-gray-400 border border-gray-500/30'); ?>">
                    <?php echo e($timer->is_enabled ? '●' : '○'); ?>

                </span>
            </div>

            <div class="mb-4">
                <span class="text-xs text-gray-500 uppercase">Interval</span>
                <p class="text-sm text-gray-300 font-medium">Every <?php echo e($timer->interval_minutes); ?> minutes</p>
            </div>

            <div class="flex space-x-2 pt-3 border-t border-gray-700">
                <a href="<?php echo e(route('tenant.timers.edit', [$tenant, $timer])); ?>" class="flex-1 text-center px-3 py-2 bg-indigo-600 hover:bg-indigo-500 text-white text-sm rounded-lg font-medium transition-colors">
                    Edit
                </a>
                <form method="POST" action="<?php echo e(route('tenant.timers.destroy', [$tenant, $timer])); ?>" class="flex-1" onsubmit="return confirm('Delete this timer?');">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="w-full px-3 py-2 bg-red-600 hover:bg-red-500 text-white text-sm rounded-lg font-medium transition-colors">
                        Delete
                    </button>
                </form>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl p-8 text-center">
            <svg class="mx-auto h-12 w-12 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
            <h3 class="mt-2 text-base font-medium text-gray-400">No timers yet</h3>
            <p class="mt-1 text-sm text-gray-500">Get started by creating your first automated timer.</p>
            <div class="mt-6">
                <a href="<?php echo e(route('tenant.timers.create', $tenant)); ?>" class="inline-flex items-center px-4 py-2 bg-indigo-600 hover:bg-indigo-500 text-white rounded-lg font-medium shadow-lg transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                    </svg>
                    Create Timer
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if($timers->hasPages()): ?>
    <div class="mt-6">
        <?php echo e($timers->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/hasnaintech/phxbot.com/resources/views/tenant/timers/index.blade.php ENDPATH**/ ?>