<?php

use App\Models\User;

test('dashboard requires authentication', function () {
    $response = $this->get('/dashboard');

    $response->assertRedirect('/login');
});

test('authenticated user can access dashboard', function () {
    $user = createUser();

    $response = $this->actingAs($user)->get('/dashboard');

    $response->assertOk();
    $response->assertSee('Dashboard');
});

test('dashboard shows tenants for user', function () {
    $user = createUser();
    $tenant = createTenant($user);

    $response = $this->actingAs($user)->get('/dashboard');

    $response->assertOk();
    $response->assertSee($tenant->channel_title);
});

test('user can start bot for their tenant', function () {
    $user = createUser();
    $tenant = createTenant($user);

    // Create oauth token
    $tenant->oauthTokens()->create([
        'provider' => 'google',
        'access_token' => 'fake_token',
        'refresh_token' => 'fake_refresh',
        'expires_at' => now()->addHour(),
    ]);

    $response = $this->actingAs($user)->post(route('tenant.start', $tenant));

    $response->assertRedirect();
    $tenant->refresh();
    expect($tenant->status)->toBe('running');
});

test('user cannot start another users tenant', function () {
    $user1 = createUser();
    $user2 = createUser();
    $tenant = createTenant($user2);

    $response = $this->actingAs($user1)->post(route('tenant.start', $tenant));

    $response->assertForbidden();
});

test('admin can access admin panel', function () {
    $admin = createUser(isAdmin: true);

    $response = $this->actingAs($admin)->get(route('admin.index'));

    $response->assertOk();
});

test('non-admin cannot access admin panel', function () {
    $user = createUser(isAdmin: false);

    $response = $this->actingAs($user)->get(route('admin.index'));

    $response->assertForbidden();
});
