<?php

use Illuminate\Foundation\Testing\RefreshDatabase;

/*
|--------------------------------------------------------------------------
| Test Case
|--------------------------------------------------------------------------
*/

uses(
    Tests\TestCase::class,
    RefreshDatabase::class,
)->in('Feature', 'Unit');

/*
|--------------------------------------------------------------------------
| Expectations
|--------------------------------------------------------------------------
*/

expect()->extend('toBeOne', function () {
    return $this->toBe(1);
});

/*
|--------------------------------------------------------------------------
| Functions
|--------------------------------------------------------------------------
*/

function createUser($isAdmin = false)
{
    return \App\Models\User::factory()->create([
        'is_admin' => $isAdmin,
    ]);
}

function createTenant($user = null)
{
    return \App\Models\Tenant::factory()->create([
        'user_id' => $user?->id ?? createUser()->id,
    ]);
}

function createCommand($tenant = null, $attributes = [])
{
    return \App\Models\Command::factory()->create(array_merge([
        'tenant_id' => $tenant?->id ?? createTenant()->id,
    ], $attributes));
}
