# PXEBot - cPanel Deployment Guide

## ⚠️ IMPORTANT WARNING

**Shared hosting will NOT work properly for PXEBot!**

This bot requires:
- ❌ Background processes (YouTube chat polling)
- ❌ Laravel Horizon (queue workers)
- ❌ Cron jobs (every second)
- ❌ Redis (for real-time performance)

**Shared hosting can't provide these. Bot will NOT function.**

**Recommended:** Use VPS instead ($5/month):
- DigitalOcean
- Vultr
- Linode
- AWS Lightsail

---

## If You Still Want to Try (Limited Functionality)

### Step 1: cPanel Database Setup

1. Login to cPanel
2. **MySQL Databases** → Create database:
   - Name: `phxbot_pxebot`
   - User: `phxbot_user`
   - Password: (strong password)
   - Grant ALL privileges

3. Note down:
   - Database name
   - Database username
   - Database password
   - Database host (usually `localhost`)

---

### Step 2: Upload Files

#### Option A: File Manager

1. cPanel → **File Manager**
2. Navigate to `public_html`
3. Create folder: `pxebot`
4. Upload entire project folder to `public_html/pxebot`

#### Option B: FTP (Recommended)

1. Use FileZilla/Cyberduck
2. Connect to your cPanel FTP
3. Upload to `/public_html/pxebot/`

---

### Step 3: Configure Environment

1. Rename `.env.production` to `.env`
2. Edit `.env` file:

```env
APP_NAME=PXEBot
APP_ENV=production
APP_KEY=base64:YOUR_KEY_HERE
APP_DEBUG=false
APP_TIMEZONE=UTC
APP_URL=https://phxbot.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=phxbot_pxebot
DB_USERNAME=phxbot_user
DB_PASSWORD=your_database_password

CACHE_STORE=database
SESSION_DRIVER=database
SESSION_LIFETIME=120
QUEUE_CONNECTION=database

# YouTube OAuth (from Google Cloud Console)
YT_CLIENT_ID=your-client-id.apps.googleusercontent.com
YT_CLIENT_SECRET=your-client-secret
YT_REDIRECT_URI=https://phxbot.com/oauth/google/callback

# OpenAI
OPENAI_API_KEY=sk-proj-your-key
OPENAI_MODEL=gpt-4o-mini
```

---

### Step 4: Set Document Root

1. cPanel → **Domains**
2. Click your domain `phxbot.com`
3. Change **Document Root** to: `/public_html/pxebot/public`
4. Save

---

### Step 5: Run Migrations

**SSH Access Required** (ask your hosting provider if available)

```bash
cd public_html/pxebot
php artisan migrate --force
php artisan storage:link
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

If SSH not available:
- Use cPanel **Terminal** (if available)
- Or install phpMyAdmin and import database manually

---

### Step 6: Set Permissions

```bash
chmod -R 755 storage bootstrap/cache
chmod -R 775 storage
```

Or via cPanel File Manager:
- Right click `storage` → Permissions → `755`
- Right click `bootstrap/cache` → Permissions → `755`

---

### Step 7: Create .htaccess

In `public_html/pxebot/public/.htaccess`:

```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

---

## ⚠️ Limitations on Shared Hosting

### What Will Work:
✅ User registration/login
✅ Dashboard display
✅ Settings management
✅ Database storage

### What Will NOT Work:
❌ YouTube chat polling (requires background process)
❌ Bot auto-replies (requires queue worker)
❌ Timers (requires scheduler)
❌ Real-time monitoring
❌ Giveaways (requires active polling)

---

## Recommended: Switch to VPS

### DigitalOcean Deployment ($5/month)

```bash
# Create droplet, then:
git clone your-repo
cd pxebot
composer install --no-dev
php artisan migrate --force
php artisan queue:work --daemon &
```

Full VPS tutorial: See `DEPLOYMENT.md`

---

## Support

For proper deployment help:
- Check `DEPLOYMENT.md` (VPS deployment)
- Check `README.md` (full setup)

**This bot is NOT designed for shared hosting!**
