# PXEBot - Fresh cPanel Setup Guide (Start to Finish)

Server se sab delete kar diya hai, ab fresh setup karte hain.

---

## 📋 Pre-Upload Checklist

### ✅ Already Done (No Action Needed):
- All credentials configured in `.env.production`
- Database credentials: hasnaintech_phxbot / VGHylVwv(t9k
- Google OAuth: Client ID & Secret added
- OpenAI API Key: Added
- All view files created
- Admin middleware created

---

## 🚀 Step-by-Step Upload & Setup

### STEP 1: Create Database (If Not Exists)

**cPanel → MySQL Databases**

1. **Create Database:**
   - Database name: `pxebot`
   - Will become: `hasnaintech_phxbot`
   - Click "Create Database"

2. **Create User:**
   - Username: `pxebot`
   - Will become: `hasnaintech_phxbot`
   - Password: `VGHylVwv(t9k`
   - Click "Create User"

3. **Add User to Database:**
   - Select user: `hasnaintech_phxbot`
   - Select database: `hasnaintech_phxbot`
   - Check "ALL PRIVILEGES"
   - Click "Add"

---

### STEP 2: Upload Files to Server

**Via FTP (FileZilla/Cyberduck) - Recommended:**

1. **Connect to cPanel FTP:**
   - Host: Your cPanel host
   - Username: Your cPanel username
   - Password: Your cPanel password

2. **Navigate to:**
   ```
   /home/hasnaintech/
   ```

3. **Upload entire folder:**
   ```
   Local: ~/Downloads/claude/pxebots/
   Upload to: /home/hasnaintech/phxbot.com/
   ```

4. **Wait for upload to complete** (~5-10 minutes depending on connection)

**Via cPanel File Manager (Alternative):**

1. **Create ZIP file locally:**
   ```bash
   cd ~/Downloads/claude/
   zip -r pxebots.zip pxebots/ -x "pxebots/node_modules/*" -x "pxebots/.git/*"
   ```

2. **Upload ZIP:**
   - cPanel → File Manager
   - Navigate to `/home/hasnaintech/`
   - Click "Upload"
   - Select `pxebots.zip`
   - Wait for upload

3. **Extract ZIP:**
   - Right-click `pxebots.zip`
   - Click "Extract"
   - Extract to: `/home/hasnaintech/`
   - Rename folder: `pxebots` → `phxbot.com`

---

### STEP 3: Setup Environment File

**Via cPanel File Manager:**

1. Navigate to: `/home/hasnaintech/phxbot.com/`

2. Find file: `.env.production`

3. Right-click → Rename → Change to: `.env`

4. Click `.env` → Edit

5. **Verify these values are correct:**
   ```env
   APP_URL=https://phxbot.com

   DB_HOST=localhost
   DB_DATABASE=hasnaintech_phxbot
   DB_USERNAME=hasnaintech_phxbot
   DB_PASSWORD=VGHylVwv(t9k

   YT_CLIENT_ID=462694888013-ha9grtb6o0mbgvd6cgnhpl4of06dnbju.apps.googleusercontent.com
   YT_CLIENT_SECRET=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

   OPENAI_API_KEY=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
   ```

6. Save and Close

---

### STEP 4: Set File Permissions

**Via cPanel File Manager:**

1. Navigate to: `/home/hasnaintech/phxbot.com/`

2. **Set storage permissions:**
   - Right-click `storage` folder
   - Click "Change Permissions"
   - Set to: `775`
   - Check "Recurse into subdirectories"
   - Click "Change"

3. **Set bootstrap/cache permissions:**
   - Navigate to `bootstrap/cache`
   - Right-click folder
   - Click "Change Permissions"
   - Set to: `755`
   - Click "Change"

**Via Terminal (if available):**
```bash
cd /home/hasnaintech/phxbot.com
chmod -R 775 storage
chmod -R 755 bootstrap/cache
```

---

### STEP 5: Change Domain Document Root

**cPanel → Domains**

1. Find domain: `phxbot.com`

2. Click "Manage" or click the domain name

3. Find "Document Root" field

4. Change from:
   ```
   /home/hasnaintech/public_html
   ```
   To:
   ```
   /home/hasnaintech/phxbot.com/public
   ```

5. Click "Save" or "Update"

6. Wait 1-2 minutes for change to propagate

---

### STEP 6: Set PHP Version

**cPanel → MultiPHP Manager** (or "Select PHP Version")

1. Find domain: `phxbot.com`

2. Select PHP version: **8.2** or **8.3** (if available)

3. Click "Apply"

4. **Enable PHP Extensions** (if option available):
   - ✅ bcmath
   - ✅ ctype
   - ✅ fileinfo
   - ✅ json
   - ✅ mbstring
   - ✅ openssl
   - ✅ pdo
   - ✅ pdo_mysql
   - ✅ tokenizer
   - ✅ xml
   - ✅ curl

---

### STEP 7: Run Database Migrations

**Via cPanel Terminal (or SSH):**

1. Open Terminal in cPanel

2. Navigate to project:
   ```bash
   cd /home/hasnaintech/phxbot.com
   ```

3. Run migrations:
   ```bash
   php artisan migrate --force
   ```

4. If specific PHP version needed:
   ```bash
   /opt/cpanel/ea-php82/root/usr/bin/php artisan migrate --force
   ```

5. Expected output:
   ```
   Migration table created successfully.
   Migrating: 2014_10_12_000000_create_users_table
   Migrated:  2014_10_12_000000_create_users_table (XX.XXms)
   ...
   ```

6. Create storage link:
   ```bash
   php artisan storage:link
   ```

7. Clear and cache:
   ```bash
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```

**If Terminal Not Available:**
- Ask hosting support to enable Terminal
- Or run migrations via custom PHP script (advanced)

---

### STEP 8: Verify .htaccess Exists

**Check:** `/home/hasnaintech/phxbot.com/public/.htaccess`

Should contain:
```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>

# php -- BEGIN cPanel-generated handler
<IfModule mime_module>
  AddHandler application/x-httpd-ea-php82 .php .php8 .phtml
</IfModule>
# php -- END cPanel-generated handler
```

If missing, create it via File Manager.

---

### STEP 9: Test Website

**Visit these URLs in order:**

1. **Homepage:**
   ```
   https://phxbot.com
   ```
   Should show: PXEBot welcome page

2. **Health Check:**
   ```
   https://phxbot.com/health
   ```
   Should show: `{"status":"ok","timestamp":"..."}`

3. **Register:**
   ```
   https://phxbot.com/register
   ```
   Create account with your email

4. **Login:**
   ```
   https://phxbot.com/login
   ```
   Login with created account

5. **Dashboard:**
   ```
   https://phxbot.com/dashboard
   ```
   Should show: PXEBot dashboard

6. **Connect YouTube:**
   - Click "Connect YouTube" button
   - Should redirect to Google OAuth
   - Accept permissions
   - Should return to dashboard

---

### STEP 10: Make User Admin

**Via phpMyAdmin (cPanel → phpMyAdmin):**

1. Select database: `hasnaintech_phxbot`

2. Click table: `users`

3. Find your user (by email)

4. Click "Edit"

5. Change `is_admin` from `0` to `1`

6. Click "Go" to save

**Via Terminal:**
```bash
mysql -u hasnaintech_phxbot -p'VGHylVwv(t9k' hasnaintech_phxbot -e "UPDATE users SET is_admin = 1 WHERE email = 'your@email.com';"
```

---

### STEP 11: Test Admin Panel

**Visit:**
```
https://phxbot.com/admin
```

Should show:
- Total Tenants count
- Active Tenants count
- Total Commands count
- Total Messages count
- List of all tenants

---

### STEP 12: Test Commands & Timers

After connecting YouTube channel:

**Commands:**
- List: `https://phxbot.com/tenants/1/commands`
- Create: `https://phxbot.com/tenants/1/commands/create`
- Should NOT show 500 error ✅

**Timers:**
- List: `https://phxbot.com/tenants/1/timers`
- Create: `https://phxbot.com/tenants/1/timers/create`
- Should NOT show 500 error ✅

---

## 🐛 Troubleshooting

### Issue: 500 Error on Any Page

**Check error logs:**
```
cPanel → Metrics → Errors
OR
/home/hasnaintech/phxbot.com/storage/logs/laravel.log
```

**Common fixes:**
```bash
cd /home/hasnaintech/phxbot.com

# Clear cache
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear

# Rebuild cache
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Fix permissions
chmod -R 775 storage
chmod -R 755 bootstrap/cache
```

### Issue: Database Connection Failed

**Verify in .env:**
```env
DB_HOST=localhost  (NOT 127.0.0.1)
DB_DATABASE=hasnaintech_phxbot  (with cPanel prefix)
DB_USERNAME=hasnaintech_phxbot  (with cPanel prefix)
DB_PASSWORD=VGHylVwv(t9k  (exact password)
```

### Issue: 404 on All Pages

**Check document root:**
- Should be: `/home/hasnaintech/phxbot.com/public`
- NOT: `/home/hasnaintech/public_html`

**Check .htaccess:**
- File: `/home/hasnaintech/phxbot.com/public/.htaccess`
- Should exist and have correct content

### Issue: White Screen / Blank Page

**Enable debug temporarily:**

Edit `.env`:
```env
APP_DEBUG=true
```

Refresh page to see error.

**IMPORTANT:** Set back to `false` after debugging!

### Issue: Permission Denied

```bash
chmod -R 775 storage
chmod -R 755 bootstrap/cache
chown -R hasnaintech:hasnaintech /home/hasnaintech/phxbot.com
```

---

## ✅ Setup Complete Checklist

- [ ] Database created
- [ ] Files uploaded to `/home/hasnaintech/phxbot.com/`
- [ ] `.env.production` renamed to `.env`
- [ ] Permissions set (storage 775, bootstrap/cache 755)
- [ ] Document root changed to `/public` folder
- [ ] PHP version set to 8.2 or 8.3
- [ ] Migrations run successfully
- [ ] Homepage loads (https://phxbot.com)
- [ ] User registered
- [ ] User can login
- [ ] Dashboard loads
- [ ] YouTube OAuth works
- [ ] User made admin in database
- [ ] Admin panel accessible
- [ ] Commands/Timers pages work (no 500 errors)

---

## 🎯 Final Test URLs

All these should work without errors:
- ✅ https://phxbot.com/
- ✅ https://phxbot.com/health
- ✅ https://phxbot.com/register
- ✅ https://phxbot.com/login
- ✅ https://phxbot.com/dashboard
- ✅ https://phxbot.com/tenants/1/commands
- ✅ https://phxbot.com/tenants/1/commands/create
- ✅ https://phxbot.com/tenants/1/timers
- ✅ https://phxbot.com/tenants/1/timers/create
- ✅ https://phxbot.com/admin

---

## ⚠️ Important Notes

**Shared Hosting Limitations:**
- YouTube chat polling will NOT work
- Bot auto-replies will NOT work
- Only UI and settings will work

**For Full Bot Functionality:**
- Need VPS hosting ($5/month)
- See `DEPLOYMENT.md` for VPS setup

---

## 🆘 Need Help?

If any step fails, check error logs:
```
cPanel → Metrics → Errors
/home/hasnaintech/phxbot.com/storage/logs/laravel.log
```

Then run:
```bash
php artisan config:clear
php artisan cache:clear
php artisan view:clear
```

---

## 🚀 You're Done!

Follow steps 1-12 in order and everything will work!

Estimated time: 15-20 minutes

---

Last Updated: 2025-11-07 04:45 AM
