# ⚡ PXEBot Quick Start Guide

Get your YouTube chatbot running in **under 5 minutes**!

---

## Prerequisites

- Docker & Docker Compose installed
- Google Cloud account
- OpenAI API key

---

## Step 1: Google Cloud Setup (2 minutes)

### Create OAuth Credentials

1. Go to https://console.cloud.google.com/
2. Create new project: "PXEBot"
3. Enable **YouTube Data API v3**
4. Go to **Credentials** → **+ CREATE CREDENTIALS** → **OAuth client ID**
5. Application type: **Web application**
6. Authorized redirect URIs:
   ```
   http://localhost/oauth/google/callback
   ```
7. Copy **Client ID** and **Client Secret**

---

## Step 2: OpenAI Setup (1 minute)

1. Go to https://platform.openai.com/api-keys
2. Create new secret key
3. Copy the key (starts with `sk-proj-...`)

---

## Step 3: Launch Application (2 minutes)

```bash
# 1. Navigate to project
cd pxebots

# 2. Copy environment file
cp .env.example .env

# 3. Edit .env with your credentials
nano .env
# Set these values:
#   YT_CLIENT_ID=your-client-id-here
#   YT_CLIENT_SECRET=your-client-secret-here
#   OPENAI_API_KEY=sk-proj-your-key-here

# 4. Start Docker services
docker-compose up -d

# 5. Install dependencies & setup
docker-compose exec app composer install
docker-compose exec app php artisan key:generate
docker-compose exec app php artisan migrate --seed
docker-compose exec app php artisan storage:link

# 6. Done! Access the app
echo "Visit http://localhost"
```

---

## Step 4: Connect Your YouTube Channel

1. Open http://localhost
2. Click **Register** → Create account
3. Go to **Dashboard**
4. Click **"Connect YouTube Channel"**
5. Authorize with Google
6. Click **"Start Bot"**

---

## Step 5: Test It Out

### Create Your First Command

1. Dashboard → Click **Commands**
2. Click **+ Add Command**
3. Fill in:
   - Name: `discord`
   - Response: `Join our Discord: https://discord.gg/yourserver`
   - Cooldown: `10`
   - Required Role: `viewer`
   - Enabled: ✅
4. Click **Save**

### Test in YouTube Live Chat

1. Start a YouTube live stream
2. In chat, type: `!discord`
3. Bot replies with your Discord link!
4. Try: `!help`, `!ping`, `!uptime`

---

## 🎯 Available Built-in Commands

| Command | Description |
|---------|-------------|
| `!help` | Show available commands |
| `!commands` | List custom commands |
| `!uptime` | Stream duration |
| `!discord` | Discord link (set in settings) |
| `!lurk` | Thank user for lurking |
| `!unlurk` | Welcome back |
| `!so <user>` | Shoutout to user |
| `!rules` | Channel rules |
| `!ping` | Check bot status |

---

## 🤖 OpenAI Auto-Replies

The bot automatically answers questions in chat!

**Example:**
- User: "What time is the next stream?"
- Bot: [OpenAI generates contextual reply in same language]

**Supported:**
- Any language (auto-detected)
- Questions ending with `?`
- Messages starting with question words (who, what, when, where, why, how)

---

## 📊 Dashboard Overview

Your dashboard shows:
- ✅ Bot status (stopped/running/error)
- ✅ Activity stats (messages per minute/hour)
- ✅ Rate limit quotas
- ✅ Recent chat messages
- ✅ Start/Stop controls
- ✅ Quick access to Commands/Timers

---

## 🔧 Common Issues

### "OAuth redirect URI mismatch"
- Ensure `YT_REDIRECT_URI` in `.env` matches Google Cloud Console exactly
- Default: `http://localhost/oauth/google/callback`

### "Bot not responding in chat"
- Check bot status is "RUNNING" in dashboard
- Verify you're streaming live (not scheduled)
- Check Horizon is running: http://localhost/horizon

### "Queue not processing"
```bash
docker-compose restart horizon
```

### "Database connection error"
```bash
docker-compose down
docker-compose up -d
docker-compose exec app php artisan migrate
```

---

## 🚀 Next Steps

### Add a Timer

1. Dashboard → **Timers** → **+ Add Timer**
2. Example:
   - Name: Subscribe Reminder
   - Message: Don't forget to subscribe! 🔔
   - Interval: `10` minutes
   - Activity Window: `5` minutes
3. Timer fires every ~10 minutes if chat is active

### Create Moderation Filter

1. Dashboard → **Filters** → **+ Add Filter**
2. Example (Block Links):
   - Type: `links`
   - Action: `warn`
   - Enabled: ✅
3. Bot warns users who post links

### Start a Giveaway

1. Dashboard → **Giveaways** → **Start New**
2. Keyword: `!enter`
3. Winners: `1`
4. Users type `!enter` to join
5. Click **Pick Winners** when ready

---

## 📱 Access Points

- **Application**: http://localhost
- **Horizon Dashboard**: http://localhost/horizon
- **Health Check**: http://localhost/health

---

## 🛑 Stop/Restart

```bash
# Stop all services
docker-compose down

# Restart
docker-compose up -d

# View logs
docker-compose logs -f app

# Restart just Horizon
docker-compose restart horizon
```

---

## 💡 Tips

1. **Test with a scheduled stream** before going live
2. **Create commands for your most FAQ** (social media, schedule, etc.)
3. **Use variables in commands**: `{user}`, `{uptime}`, `{channel}`
4. **Set timers for key messages** (merch, sponsor, social links)
5. **Monitor Horizon dashboard** during streams
6. **Check rate limits** if bot stops responding

---

## 📖 Full Documentation

- **README.md** - Complete feature guide
- **DEPLOYMENT.md** - Production deployment
- **PROJECT_SUMMARY.md** - Technical details

---

## ⚡ That's It!

You now have a fully functional YouTube chatbot with:
- ✅ Custom commands
- ✅ OpenAI Q&A
- ✅ Timers
- ✅ Moderation
- ✅ Giveaways

**Happy streaming! 🎥**

---

Domain: **phxbot.com** | Bot: **PXEBot**
