# 500 Server Error - Troubleshooting Guide

## Current Issue
Getting 500 Server Error on:
- https://phxbot.com/tenants/1/commands/create
- https://phxbot.com/tenants/1/timers

## Common Causes & Solutions

### 1. Check Error Logs (MOST IMPORTANT)

**In cPanel:**
- Go to **cPanel → Metrics → Errors**
- Or check: `/home/hasnaintech/public_html/pxebot/storage/logs/laravel.log`

**Via File Manager:**
- Navigate to: `public_html/pxebot/storage/logs/`
- Open `laravel.log` (most recent entries at bottom)
- Look for the actual error message

---

### 2. File Permissions Issue

**Fix via SSH/Terminal:**
```bash
cd /home/hasnaintech/public_html/pxebot
chmod -R 755 storage bootstrap/cache
chmod -R 775 storage
```

**Or via cPanel File Manager:**
- Right-click `storage` folder → Permissions → 775
- Right-click `bootstrap/cache` folder → Permissions → 755

---

### 3. Missing Storage Symlink

**Run via SSH:**
```bash
cd /home/hasnaintech/public_html/pxebot
php artisan storage:link
```

Or use PHP 8.2/8.3 specifically:
```bash
/opt/cpanel/ea-php82/root/usr/bin/php artisan storage:link
```

---

### 4. Clear Cache

**Run via SSH:**
```bash
cd /home/hasnaintech/public_html/pxebot
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear
```

Then rebuild cache:
```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

---

### 5. Check .env File

**Verify .env exists and is named correctly:**
- File should be: `/public_html/pxebot/.env` (NOT `.env.production`)
- Check database credentials are correct
- Check APP_KEY exists

**Regenerate APP_KEY if needed:**
```bash
php artisan key:generate
```

---

### 6. Database Connection Issue

**Test database connection via SSH:**
```bash
php artisan migrate:status
```

If database error:
- Verify DB_HOST=localhost
- Verify DB_DATABASE=hasnaintech_phxbot
- Verify DB_USERNAME=hasnaintech_phxbot
- Verify DB_PASSWORD=VGHylVwv(t9k

---

### 7. PHP Version & Extensions

**Check PHP version:**
```bash
php -v
```

Should show: PHP 8.2+ or PHP 8.3+

**Check required extensions:**
```bash
php -m
```

Should include:
- PDO
- pdo_mysql
- mbstring
- openssl
- tokenizer
- xml
- ctype
- json
- bcmath
- fileinfo

---

### 8. .htaccess Missing or Incorrect

**Check file exists:**
`/public_html/pxebot/public/.htaccess`

**Should contain:**
```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Front Controller
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

---

### 9. Composer Autoload Issue

**Regenerate autoload:**
```bash
cd /home/hasnaintech/public_html/pxebot
composer dump-autoload
```

Or with specific PHP version:
```bash
/opt/cpanel/ea-php82/root/usr/bin/php /usr/local/bin/composer dump-autoload
```

---

### 10. Check Migrations Ran Successfully

**Check migration status:**
```bash
php artisan migrate:status
```

**If not run, run migrations:**
```bash
php artisan migrate --force
```

---

## Debug Steps (In Order)

1. **Check error logs first** (cPanel → Errors or storage/logs/laravel.log)
2. **Fix permissions** (storage 775, bootstrap/cache 755)
3. **Clear all cache** (config, view, route cache)
4. **Verify .env exists** and has correct values
5. **Test database connection** (migrate:status)
6. **Check PHP version** (should be 8.2+)
7. **Regenerate autoload** (composer dump-autoload)

---

## Most Likely Issues

### Issue 1: Storage Directory Not Writable
**Error in logs:** "The stream or file could not be opened"
**Fix:** `chmod -R 775 storage`

### Issue 2: Route Cache Outdated
**Error:** Routes not found or 500 on specific routes
**Fix:**
```bash
php artisan route:clear
php artisan route:cache
```

### Issue 3: Config Cache with Wrong Path
**Error:** Various 500 errors after upload
**Fix:**
```bash
php artisan config:clear
php artisan config:cache
```

### Issue 4: Missing Migrations
**Error:** Database tables don't exist
**Fix:**
```bash
php artisan migrate --force
```

---

## Get Detailed Error Message

**Enable debug mode temporarily:**

Edit `.env` file:
```env
APP_DEBUG=true
```

Visit the error page again - you'll see detailed error message.

**IMPORTANT:** Set back to `false` after debugging!

---

## Contact Hosting Support If:

1. PHP 8.2/8.3 not available
2. Can't change file permissions
3. Can't access SSH/Terminal
4. mod_rewrite not enabled
5. PHP extensions missing

---

## Quick Fix Commands (Run All)

```bash
cd /home/hasnaintech/public_html/pxebot

# Clear all cache
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear

# Fix permissions
chmod -R 775 storage
chmod -R 755 bootstrap/cache

# Rebuild cache
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Storage link
php artisan storage:link

# Check migrations
php artisan migrate:status
```

---

**Start with checking the error logs - that will tell you the exact issue!**
