<?php

namespace App\Console\Commands;

use App\Models\Tenant;
use Illuminate\Console\Command;

class BotControl extends Command
{
    protected $signature = 'bot:control {action} {--tenant=}';
    protected $description = 'Control bot status (start|stop|restart|status)';

    public function handle(): int
    {
        $action = $this->argument('action');
        $tenantId = $this->option('tenant');

        if ($tenantId) {
            $tenant = Tenant::find($tenantId);
            if (!$tenant) {
                $this->error("Tenant #{$tenantId} not found");
                return self::FAILURE;
            }

            return $this->controlTenant($tenant, $action);
        }

        // Apply to all tenants
        $tenants = Tenant::all();
        foreach ($tenants as $tenant) {
            $this->controlTenant($tenant, $action);
        }

        return self::SUCCESS;
    }

    private function controlTenant(Tenant $tenant, string $action): int
    {
        switch ($action) {
            case 'start':
                $tenant->update(['status' => 'running']);
                $this->info("Started bot for tenant #{$tenant->id} ({$tenant->channel_title})");
                break;

            case 'stop':
                $tenant->update(['status' => 'stopped']);
                $this->info("Stopped bot for tenant #{$tenant->id} ({$tenant->channel_title})");
                break;

            case 'restart':
                $tenant->update(['status' => 'stopped']);
                $tenant->update(['status' => 'running']);
                $this->info("Restarted bot for tenant #{$tenant->id} ({$tenant->channel_title})");
                break;

            case 'status':
                $this->line("Tenant #{$tenant->id}: {$tenant->channel_title} - Status: {$tenant->status}");
                break;

            default:
                $this->error("Unknown action: {$action}");
                return self::FAILURE;
        }

        return self::SUCCESS;
    }
}
