<?php

namespace App\Http\Requests\Command;

use Illuminate\Foundation\Http\FormRequest;

class StoreCommandRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:50', 'regex:/^[a-z0-9_]+$/'],
            'response' => ['required', 'string', 'max:500'],
            'cooldown_sec' => ['required', 'integer', 'min:0', 'max:3600'],
            'required_role' => ['required', 'in:owner,admin,mod,trusted,viewer'],
            'is_enabled' => ['boolean'],
            'aliases' => ['nullable', 'array'],
            'aliases.*' => ['string', 'max:50', 'regex:/^[a-z0-9_]+$/'],
            'variables' => ['nullable', 'array'],
        ];
    }
}
