<?php

namespace App\Jobs;

use App\Models\Tenant;
use App\Services\YouTubeService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class PostBotReply implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $timeout = 30;

    public function __construct(
        public Tenant $tenant,
        public string $text
    ) {}

    public function handle(YouTubeService $youtube): void
    {
        if (!$this->tenant->isRunning()) {
            return;
        }

        $success = $youtube->sendMessage($this->tenant, $this->text);

        if (!$success) {
            Log::warning('Failed to post bot reply', [
                'tenant_id' => $this->tenant->id,
                'text' => substr($this->text, 0, 100),
            ]);
        }
    }

    public function failed(\Throwable $exception): void
    {
        Log::error('PostBotReply job failed', [
            'tenant_id' => $this->tenant->id,
            'error' => $exception->getMessage(),
        ]);
    }
}
