<?php

namespace App\Jobs;

use App\Models\OauthToken;
use App\Services\YouTubeService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class RefreshYouTubeToken implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $timeout = 30;

    public function __construct(
        public OauthToken $token
    ) {}

    public function handle(YouTubeService $youtube): void
    {
        if (!$this->token->needsRefresh()) {
            return;
        }

        $youtube->refreshToken($this->token);
    }

    public function failed(\Throwable $exception): void
    {
        Log::error('RefreshYouTubeToken job failed', [
            'token_id' => $this->token->id,
            'tenant_id' => $this->token->tenant_id,
            'error' => $exception->getMessage(),
        ]);
    }
}
