<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MessageLog extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $table = 'messages_log';

    protected $fillable = [
        'tenant_id',
        'msg_id',
        'author_channel_id',
        'author_name',
        'text',
        'detected_lang',
        'classification',
        'handled_by',
        'posted_reply',
        'error',
        'created_at',
    ];

    protected function casts(): array
    {
        return [
            'classification' => 'array',
            'error' => 'array',
            'created_at' => 'datetime',
        ];
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
