<?php

namespace App\Policies;

use App\Models\Tenant;
use App\Models\User;

class TenantPolicy
{
    /**
     * Determine if the user can manage the tenant
     */
    public function manage(User $user, Tenant $tenant): bool
    {
        return $user->id === $tenant->user_id || $user->isAdmin();
    }

    /**
     * Determine if the user can view the tenant
     */
    public function view(User $user, Tenant $tenant): bool
    {
        return $user->id === $tenant->user_id || $user->isAdmin();
    }
}
