<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class TenantFactory extends Factory
{
    public function definition(): array
    {
        return [
            'user_id' => User::factory(),
            'channel_id' => 'UC' . fake()->uuid(),
            'channel_title' => fake()->company() . ' Gaming',
            'channel_handle' => '@' . fake()->userName(),
            'status' => 'stopped',
            'quotas' => [],
            'settings' => [],
        ];
    }

    public function running(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'running',
            'live_chat_id' => 'Cg0KCy' . fake()->uuid(),
            'active_broadcast_id' => fake()->uuid(),
            'broadcast_started_at' => now()->subHour(),
        ]);
    }
}
