<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('giveaways', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained()->onDelete('cascade');
            $table->enum('status', ['idle', 'active', 'completed'])->default('idle');
            $table->string('keyword'); // e.g., "!enter"
            $table->integer('winners_count')->default(1);
            $table->json('winners')->nullable(); // array of winner names
            $table->timestamp('started_at')->nullable();
            $table->timestamp('ended_at')->nullable();
            $table->timestamps();

            $table->index(['tenant_id', 'status']);
        });

        Schema::create('giveaway_entries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('giveaway_id')->constrained()->onDelete('cascade');
            $table->string('user_channel_id');
            $table->string('user_name');
            $table->timestamp('entered_at');

            $table->index('giveaway_id');
            $table->unique(['giveaway_id', 'user_channel_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('giveaway_entries');
        Schema::dropIfExists('giveaways');
    }
};
