@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-8">
        <a href="{{ route('admin.index') }}" class="inline-flex items-center text-gray-400 hover:text-gray-300 mb-4 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Admin
        </a>
        <h2 class="text-3xl font-bold text-white">Audit Logs</h2>
        <p class="mt-2 text-gray-400">System activity and changes</p>
    </div>

    <!-- Audit Logs Table -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800/50">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Time</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">User</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Action</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Model</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Details</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($audits as $audit)
                    <tr class="hover:bg-gray-800/30 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-400">
                            {{ $audit->created_at->format('M d, H:i:s') }}
                        </td>
                        <td class="px-6 py-4">
                            <p class="text-sm text-white">{{ $audit->user->name ?? 'System' }}</p>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs font-medium rounded-full
                                {{ $audit->action === 'created' ? 'bg-green-500/20 text-green-400' : '' }}
                                {{ $audit->action === 'updated' ? 'bg-blue-500/20 text-blue-400' : '' }}
                                {{ $audit->action === 'deleted' ? 'bg-red-500/20 text-red-400' : '' }}">
                                {{ ucfirst($audit->action) }}
                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-300">
                            {{ class_basename($audit->auditable_type) }} #{{ $audit->auditable_id }}
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-400">
                            @if($audit->changes)
                                <details class="cursor-pointer">
                                    <summary>View Changes</summary>
                                    <pre class="text-xs mt-2 p-2 bg-gray-800 rounded">{{ json_encode($audit->changes, JSON_PRETTY_PRINT) }}</pre>
                                </details>
                            @else
                                -
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center text-gray-400">
                            No audit logs found
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    @if($audits->hasPages())
    <div class="mt-6">
        {{ $audits->links() }}
    </div>
    @endif
</div>
@endsection
