@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Header -->
    <div class="mb-8 flex flex-col sm:flex-row sm:justify-between sm:items-center gap-4">
        <div>
            <h2 class="text-3xl font-bold text-white">Commands</h2>
            <p class="mt-2 text-gray-400">Manage custom commands for <span class="text-indigo-400">{{ $tenant->channel_title }}</span></p>
        </div>
        <div class="flex flex-wrap gap-3">
            <a href="{{ route('dashboard') }}" class="inline-flex items-center px-4 py-2 bg-gray-700 hover:bg-gray-600 text-gray-300 rounded-lg font-medium transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                </svg>
                Back
            </a>
            <a href="{{ route('tenant.commands.create', $tenant) }}" class="inline-flex items-center px-5 py-2 bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-500 hover:to-purple-500 text-white rounded-lg font-medium shadow-lg transform hover:scale-105 transition-all duration-200">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                </svg>
                Add Command
            </a>
        </div>
    </div>

    <!-- Commands Table (Desktop) -->
    <div class="hidden lg:block bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800/50">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Command</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Response</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Cooldown</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Role</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-gray-300 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse($commands as $command)
                    <tr class="hover:bg-gray-800/30 transition-colors">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm font-mono font-semibold text-indigo-400">!{{ $command->name }}</span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="text-sm text-gray-300">{{ \Str::limit($command->response, 60) }}</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-sm text-gray-400">{{ $command->cooldown_sec }}s</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-2 py-1 text-xs font-medium rounded-full bg-gray-700 text-gray-300">
                                {{ $command->required_role }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full {{ $command->is_enabled ? 'bg-green-500/20 text-green-400 border border-green-500/30' : 'bg-gray-500/20 text-gray-400 border border-gray-500/30' }}">
                                {{ $command->is_enabled ? 'Enabled' : 'Disabled' }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium space-x-3">
                            <a href="{{ route('tenant.commands.edit', [$tenant, $command]) }}" class="text-indigo-400 hover:text-indigo-300 transition-colors">Edit</a>
                            <form method="POST" action="{{ route('tenant.commands.destroy', [$tenant, $command]) }}" class="inline" onsubmit="return confirm('Delete this command?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-400 hover:text-red-300 transition-colors">Delete</button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center">
                            <svg class="mx-auto h-12 w-12 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                            <h3 class="mt-2 text-sm font-medium text-gray-400">No commands yet</h3>
                            <p class="mt-1 text-sm text-gray-500">Get started by creating your first custom command.</p>
                            <div class="mt-6">
                                <a href="{{ route('tenant.commands.create', $tenant) }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 hover:bg-indigo-500 text-white rounded-lg font-medium shadow-lg transition-colors">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                                    </svg>
                                    Create Command
                                </a>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Commands Cards (Mobile) -->
    <div class="lg:hidden space-y-4">
        @forelse($commands as $command)
        <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl p-5 shadow-lg">
            <div class="flex items-start justify-between mb-3">
                <div class="flex-1">
                    <span class="text-base font-mono font-semibold text-indigo-400">!{{ $command->name }}</span>
                    <p class="text-sm text-gray-300 mt-1">{{ \Str::limit($command->response, 80) }}</p>
                </div>
                <span class="px-3 py-1 text-xs font-semibold rounded-full {{ $command->is_enabled ? 'bg-green-500/20 text-green-400 border border-green-500/30' : 'bg-gray-500/20 text-gray-400 border border-gray-500/30' }}">
                    {{ $command->is_enabled ? '●' : '○' }}
                </span>
            </div>

            <div class="grid grid-cols-2 gap-3 mb-4">
                <div>
                    <span class="text-xs text-gray-500 uppercase">Cooldown</span>
                    <p class="text-sm text-gray-300 font-medium">{{ $command->cooldown_sec }}s</p>
                </div>
                <div>
                    <span class="text-xs text-gray-500 uppercase">Role</span>
                    <p class="text-sm text-gray-300 font-medium">{{ $command->required_role }}</p>
                </div>
            </div>

            <div class="flex space-x-2 pt-3 border-t border-gray-700">
                <a href="{{ route('tenant.commands.edit', [$tenant, $command]) }}" class="flex-1 text-center px-3 py-2 bg-indigo-600 hover:bg-indigo-500 text-white text-sm rounded-lg font-medium transition-colors">
                    Edit
                </a>
                <form method="POST" action="{{ route('tenant.commands.destroy', [$tenant, $command]) }}" class="flex-1" onsubmit="return confirm('Delete this command?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="w-full px-3 py-2 bg-red-600 hover:bg-red-500 text-white text-sm rounded-lg font-medium transition-colors">
                        Delete
                    </button>
                </form>
            </div>
        </div>
        @empty
        <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl p-8 text-center">
            <svg class="mx-auto h-12 w-12 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
            </svg>
            <h3 class="mt-2 text-base font-medium text-gray-400">No commands yet</h3>
            <p class="mt-1 text-sm text-gray-500">Get started by creating your first custom command.</p>
            <div class="mt-6">
                <a href="{{ route('tenant.commands.create', $tenant) }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 hover:bg-indigo-500 text-white rounded-lg font-medium shadow-lg transition-colors">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
                    </svg>
                    Create Command
                </a>
            </div>
        </div>
        @endforelse
    </div>

    <!-- Pagination -->
    @if($commands->hasPages())
    <div class="mt-6">
        {{ $commands->links() }}
    </div>
    @endif
</div>
@endsection
