@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Header -->
    <div class="mb-8">
        <a href="{{ route('tenant.timers.index', $tenant) }}" class="inline-flex items-center text-gray-400 hover:text-gray-300 mb-4 transition-colors">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Timers
        </a>
        <h2 class="text-3xl font-bold text-white">Create Timer</h2>
        <p class="mt-2 text-gray-400">Add a new automated timer for <span class="text-indigo-400">{{ $tenant->channel_title }}</span></p>
    </div>

    <!-- Form -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl p-6 sm:p-8">
        <form method="POST" action="{{ route('tenant.timers.store', $tenant) }}" class="space-y-6">
            @csrf

            <!-- Timer Name -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-300 mb-2">
                    Timer Name <span class="text-red-400">*</span>
                </label>
                <input
                    type="text"
                    id="name"
                    name="name"
                    required
                    value="{{ old('name') }}"
                    placeholder="Discord Reminder"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all"
                >
                @error('name')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-gray-500">A friendly name to identify this timer</p>
            </div>

            <!-- Message -->
            <div>
                <label for="message" class="block text-sm font-medium text-gray-300 mb-2">
                    Message <span class="text-red-400">*</span>
                </label>
                <textarea
                    id="message"
                    name="message"
                    required
                    rows="4"
                    placeholder="Join our Discord server: https://discord.gg/example"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all resize-y"
                >{{ old('message') }}</textarea>
                @error('message')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-gray-500">The message that will be sent automatically</p>
            </div>

            <!-- Interval -->
            <div>
                <label for="interval_min" class="block text-sm font-medium text-gray-300 mb-2">
                    Interval (minutes) <span class="text-red-400">*</span>
                </label>
                <input
                    type="number"
                    id="interval_min"
                    name="interval_min"
                    required
                    min="1"
                    max="1440"
                    value="{{ old('interval_min', 10) }}"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all"
                >
                @error('interval_min')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-gray-500">How often this message should be sent (1-1440 minutes)</p>
            </div>

            <!-- Chat Activity Window -->
            <div>
                <label for="chat_activity_window_min" class="block text-sm font-medium text-gray-300 mb-2">
                    Chat Activity Window (minutes) <span class="text-red-400">*</span>
                </label>
                <input
                    type="number"
                    id="chat_activity_window_min"
                    name="chat_activity_window_min"
                    required
                    min="1"
                    max="60"
                    value="{{ old('chat_activity_window_min', 10) }}"
                    class="w-full bg-gray-700 border border-gray-600 rounded-lg px-4 py-3 text-white placeholder-gray-500 focus:ring-2 focus:ring-indigo-500 focus:border-transparent transition-all"
                >
                @error('chat_activity_window_min')
                    <p class="mt-1 text-sm text-red-400">{{ $message }}</p>
                @enderror
                <p class="mt-1 text-xs text-gray-500">Minimum chat activity required before timer fires (1-60 minutes)</p>
            </div>

            <!-- Enabled -->
            <div class="flex items-center">
                <input
                    type="checkbox"
                    id="is_enabled"
                    name="is_enabled"
                    value="1"
                    {{ old('is_enabled', true) ? 'checked' : '' }}
                    class="w-4 h-4 text-indigo-600 bg-gray-700 border-gray-600 rounded focus:ring-2 focus:ring-indigo-500"
                >
                <label for="is_enabled" class="ml-3 text-sm font-medium text-gray-300">
                    Enable this timer
                </label>
            </div>

            <!-- Submit -->
            <div class="flex justify-end space-x-3 pt-4">
                <a
                    href="{{ route('tenant.timers.index', $tenant) }}"
                    class="px-6 py-3 bg-gray-700 hover:bg-gray-600 text-gray-300 rounded-lg font-medium transition-colors"
                >
                    Cancel
                </a>
                <button
                    type="submit"
                    class="px-6 py-3 bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-500 hover:to-purple-500 text-white rounded-lg font-medium shadow-lg transform hover:scale-105 transition-all duration-200"
                >
                    Create Timer
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
