<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Auth\GoogleOAuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Tenant\CommandController;
use App\Http\Controllers\Tenant\TenantController;
use App\Http\Controllers\Tenant\TimerController;
use Illuminate\Support\Facades\Route;

// Public routes
Route::get('/', function () {
    return view('welcome');
});

Route::get('/health', function () {
    return response()->json([
        'status' => 'ok',
        'timestamp' => now()->toIso8601String(),
    ]);
})->name('health');

// Auth routes (Breeze)
require __DIR__.'/auth.php';

// Test route
require __DIR__.'/test-admin.php';

// Authenticated routes
Route::middleware(['auth', 'verified'])->group(function () {
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Google OAuth
    Route::prefix('oauth/google')->name('oauth.google.')->group(function () {
        Route::get('redirect', [GoogleOAuthController::class, 'redirect'])->name('redirect');
        Route::get('callback', [GoogleOAuthController::class, 'callback'])->name('callback');
    });

    // Tenant management
    Route::prefix('tenants/{tenant}')->name('tenant.')->group(function () {
        Route::post('start', [TenantController::class, 'start'])->name('start');
        Route::post('stop', [TenantController::class, 'stop'])->name('stop');
        Route::delete('/', [TenantController::class, 'destroy'])->name('destroy');
        Route::post('settings/toggle/{key}', [TenantController::class, 'toggleSetting'])->name('settings.toggle');

        // Commands
        Route::resource('commands', CommandController::class)->except(['show']);

        // Timers
        Route::resource('timers', TimerController::class)->except(['show']);
    });

    // Admin routes
    Route::middleware(\App\Http\Middleware\EnsureUserIsAdmin::class)->prefix('admin')->name('admin.')->group(function () {
        Route::get('/', [AdminController::class, 'index'])->name('index');
        Route::post('tenants/{tenant}/force-stop', [AdminController::class, 'forceStop'])->name('tenants.force-stop');
        Route::post('tenants/{tenant}/force-start', [AdminController::class, 'forceStart'])->name('tenants.force-start');
        Route::get('tenants/{tenant}/logs', [AdminController::class, 'logs'])->name('tenants.logs');
        Route::get('audits', [AdminController::class, 'audits'])->name('audits');
    });
});
