<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-8">
        <h2 class="text-3xl font-bold text-white">Admin Dashboard</h2>
        <p class="mt-2 text-gray-400">System overview and tenant management</p>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="bg-gradient-to-br from-indigo-600 to-indigo-800 rounded-xl p-6 shadow-lg">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-indigo-200 text-sm font-medium">Total Tenants</p>
                    <p class="text-3xl font-bold text-white mt-2"><?php echo e($stats['total_tenants'] ?? 0); ?></p>
                </div>
                <svg class="w-12 h-12 text-indigo-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                </svg>
            </div>
        </div>

        <div class="bg-gradient-to-br from-green-600 to-green-800 rounded-xl p-6 shadow-lg">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-green-200 text-sm font-medium">Active Tenants</p>
                    <p class="text-3xl font-bold text-white mt-2"><?php echo e($stats['active_tenants'] ?? 0); ?></p>
                </div>
                <svg class="w-12 h-12 text-green-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
            </div>
        </div>

        <div class="bg-gradient-to-br from-purple-600 to-purple-800 rounded-xl p-6 shadow-lg">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-purple-200 text-sm font-medium">Total Commands</p>
                    <p class="text-3xl font-bold text-white mt-2"><?php echo e($stats['total_commands'] ?? 0); ?></p>
                </div>
                <svg class="w-12 h-12 text-purple-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 9l3 3-3 3m5 0h3M5 20h14a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                </svg>
            </div>
        </div>

        <div class="bg-gradient-to-br from-orange-600 to-orange-800 rounded-xl p-6 shadow-lg">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-orange-200 text-sm font-medium">Total Messages</p>
                    <p class="text-3xl font-bold text-white mt-2"><?php echo e($stats['total_messages'] ?? 0); ?></p>
                </div>
                <svg class="w-12 h-12 text-orange-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
                </svg>
            </div>
        </div>
    </div>

    <!-- Tenants Table -->
    <div class="bg-gradient-to-br from-gray-800 to-gray-900 border border-gray-700 rounded-xl shadow-2xl overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-700">
            <h3 class="text-xl font-bold text-white">All Tenants</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-800/50">
                    <tr>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Channel</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">User</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Status</th>
                        <th class="px-6 py-4 text-left text-xs font-semibold text-gray-300 uppercase">Created</th>
                        <th class="px-6 py-4 text-right text-xs font-semibold text-gray-300 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $tenants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tenant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-800/30 transition-colors">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <?php if($tenant->channel_avatar_url): ?>
                                <img src="<?php echo e($tenant->channel_avatar_url); ?>" class="w-10 h-10 rounded-full mr-3" alt="Avatar">
                                <?php endif; ?>
                                <div>
                                    <p class="text-sm font-medium text-white"><?php echo e($tenant->channel_title); ?></p>
                                    <p class="text-xs text-gray-400"><?php echo e($tenant->channel_id); ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <p class="text-sm text-gray-300"><?php echo e($tenant->user->name); ?></p>
                            <p class="text-xs text-gray-400"><?php echo e($tenant->user->email); ?></p>
                        </td>
                        <td class="px-6 py-4">
                            <span class="px-3 py-1 inline-flex text-xs leading-5 font-semibold rounded-full
                                <?php echo e($tenant->status === 'running' ? 'bg-green-500/20 text-green-400' : ''); ?>

                                <?php echo e($tenant->status === 'stopped' ? 'bg-gray-500/20 text-gray-400' : ''); ?>

                                <?php echo e($tenant->status === 'error' ? 'bg-red-500/20 text-red-400' : ''); ?>">
                                <?php echo e(ucfirst($tenant->status)); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-400">
                            <?php echo e($tenant->created_at->format('M d, Y')); ?>

                        </td>
                        <td class="px-6 py-4 text-right text-sm">
                            <a href="<?php echo e(route('admin.tenants.logs', $tenant)); ?>" class="text-indigo-400 hover:text-indigo-300 mr-3">Logs</a>
                            <a href="<?php echo e(route('tenant.commands.index', $tenant)); ?>" class="text-indigo-400 hover:text-indigo-300">View</a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center text-gray-400">
                            No tenants found
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php if($tenants->hasPages()): ?>
    <div class="mt-6">
        <?php echo e($tenants->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/hasnaintech/phxbot.com/resources/views/admin/index.blade.php ENDPATH**/ ?>